/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.runtime;

import com.meidusa.toolkit.common.runtime.Shutdowner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityShutdownHook
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(PriorityShutdownHook.class);
    private static PriorityShutdownHook instance = new PriorityShutdownHook();
    private List<Shutdowner> shutdowners = Collections.synchronizedList(new ArrayList());

    static {
        Runtime.getRuntime().addShutdownHook(instance);
    }

    private PriorityShutdownHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addShutdowner(Shutdowner shutdowner) {
        PriorityShutdownHook priorityShutdownHook = instance;
        synchronized (priorityShutdownHook) {
            PriorityShutdownHook.instance.shutdowners.add(shutdowner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeShutdowner(Shutdowner shutdowner) {
        PriorityShutdownHook priorityShutdownHook = instance;
        synchronized (priorityShutdownHook) {
            PriorityShutdownHook.instance.shutdowners.remove(shutdowner);
        }
    }

    @Override
    public synchronized void run() {
        ArrayList<Shutdowner> shutDownTmp = new ArrayList<Shutdowner>();
        shutDownTmp.addAll(this.shutdowners);
        Collections.sort(shutDownTmp, new Comparator<Shutdowner>(){

            @Override
            public int compare(Shutdowner o1, Shutdowner o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        for (Shutdowner shutdowner : shutDownTmp) {
            try {
                shutdowner.shutdown();
                if (!logger.isInfoEnabled()) continue;
                logger.info("shutdowner :" + shutdowner + " shutdown completed!");
            }
            catch (Exception e) {
                logger.error("shutdowner invoke shutdown method error", (Throwable)e);
            }
        }
    }
}

