/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.runtime;

import com.meidusa.toolkit.common.runtime.Application;
import com.meidusa.toolkit.common.runtime.ApplicationConfig;
import com.meidusa.toolkit.common.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.SystemPropertyUtils;

public abstract class DefaultApplication<T extends ApplicationConfig>
extends Application<T> {
    private static Logger logger = LoggerFactory.getLogger(DefaultApplication.class);

    @Override
    protected String[] getConfigLocations() {
        File file = new File(SystemPropertyUtils.resolvePlaceholders((String)"${project.home}"), "conf");
        File springContextfile = new File(file, "springContext.properties");
        if (!springContextfile.exists()) {
            logger.warn("file not Found :" + file.getAbsolutePath());
            return null;
        }
        ArrayList<String> configs = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(springContextfile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (StringUtil.isEmpty((String)(line = line.trim())) || line.startsWith("#")) continue;
                configs.add(line);
            }
            return configs.toArray(new String[0]);
        }
        catch (FileNotFoundException e) {
            logger.warn("file not Found", (Throwable)e);
            throw new RuntimeException("file not Found", e);
        }
        catch (IOException e) {
            logger.warn("IOException", (Throwable)e);
            throw new RuntimeException("IOException", e);
        }
    }
}

