package com.meidusa.toolkit.common.runtime;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * Ӧóڲȫ
 * @author Struct
 *
 */
public class GlobalScheduler implements Shutdowner,ScheduledExecutorService{
	private static GlobalScheduler instance = new GlobalScheduler();
	private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(8);
	
	public static GlobalScheduler getInstance(){
		return instance;
	}
	
	private GlobalScheduler(){
		PriorityShutdownHook.addShutdowner(this);
	}
	
	public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay,  long period, TimeUnit unit){
		return instance.scheduler.scheduleAtFixedRate(command, initialDelay, period, unit);
	}

	public int getPriority() {
		return Thread.MIN_PRIORITY;
	}

	public void shutdown() {
		scheduler.shutdown();
	}

	public ScheduledFuture<?> schedule(Runnable command, long delay,
			TimeUnit unit) {
		return scheduler.schedule(command, delay, unit);
	}

	public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay,
			TimeUnit unit) {
		return scheduler.schedule(callable, delay, unit);
	}

	public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command,
			long initialDelay, long delay, TimeUnit unit) {
		return scheduler.scheduleWithFixedDelay(command, initialDelay, delay, unit);
	}

	public boolean awaitTermination(long timeout, TimeUnit unit)
			throws InterruptedException {
		return scheduler.awaitTermination(timeout, unit);
	}



	public boolean isShutdown() {
		return scheduler.isShutdown();
	}

	public boolean isTerminated() {
		return scheduler.isTerminated();
	}

	public List<Runnable> shutdownNow() {
		return scheduler.shutdownNow();
	}

	public <T> Future<T> submit(Callable<T> task) {
		return scheduler.submit(task);
	}

	public Future<?> submit(Runnable task) {
		return scheduler.submit(task);
	}

	public <T> Future<T> submit(Runnable task, T result) {
		return scheduler.submit(task, result);
	}

	public void execute(Runnable command) {
		scheduler.execute(command);
	}

	public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks)
			throws InterruptedException {
		return scheduler.invokeAll(tasks);
	}

	public <T> List<Future<T>> invokeAll(
			Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit)
			throws InterruptedException {
		return scheduler.invokeAll(tasks,timeout,unit);
	}

	public <T> T invokeAny(Collection<? extends Callable<T>> tasks)
			throws InterruptedException, ExecutionException {
		return scheduler.invokeAny(tasks);
	}

	public <T> T invokeAny(Collection<? extends Callable<T>> tasks,
			long timeout, TimeUnit unit) throws InterruptedException,
			ExecutionException, TimeoutException {
		return scheduler.invokeAny(tasks,timeout,unit);
	}

}
