/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.runtime;

import com.meidusa.toolkit.common.runtime.Application;
import com.meidusa.toolkit.common.runtime.Command;
import com.meidusa.toolkit.common.runtime.ShutdownRunner;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ShutdownServer
extends ShutdownRunner {
    private CountDownLatch latch = new CountDownLatch(1);

    public ShutdownServer(String appplicationName) {
        super(appplicationName);
    }

    public void waitForRun() throws Exception {
        this.latch.await(5L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        Random random = new Random();
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        ServerSocket server = null;
        int times = 0;
        do {
            try {
                int port = random.nextInt(65535);
                ++times;
                server = address != null ? new ServerSocket(port, 50, address) : new ServerSocket(port, 50);
                FileWriter writer = new FileWriter(this.socketInfoFile);
                writer.write("" + port);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                if (times <= 100) continue;
                System.out.println("cannot create shutdownServer socket,System exit now!");
                e.printStackTrace();
                System.exit(-1);
            }
        } while (server == null);
        final ServerSocket finalServer = server;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    finalServer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (ShutdownServer.this.socketInfoFile.exists()) {
                    ShutdownServer.this.socketInfoFile.delete();
                }
            }
        });
        this.latch.countDown();
        while (true) {
            try {
                while (true) {
                    final Socket socket = finalServer.accept();
                    socket.setSoTimeout(1000);
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                ObjectInputStream is = new ObjectInputStream(socket.getInputStream());
                                Command command = (Command)is.readObject();
                                if (command == Command.SHUTDOWN) {
                                    System.out.println("application shutdown now ...");
                                    ObjectOutputStream os = new ObjectOutputStream(socket.getOutputStream());
                                    os.writeObject(Command.OK);
                                    System.exit(0);
                                } else if (command == Command.PING) {
                                    ObjectOutputStream os = new ObjectOutputStream(socket.getOutputStream());
                                    os.writeObject(Command.PONG);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        ShutdownServer server = new ShutdownServer(Application.class.getSimpleName());
        server.init();
        server.start();
    }
}

