package com.meidusa.toolkit.common.runtime;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.FileWatchdog;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.Log4jConfigurer;
import org.springframework.util.SystemPropertyUtils;

import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.BeanContextBean;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;

/**
 * 
 * @author Struct
 *
 */
public abstract class Application<T extends ApplicationConfig> implements Runnable{
	private static Logger logger = Logger.getLogger(Application.class);
	protected AutowireCapableBeanFactory factory;
	private AbstractApplicationContext context;
	protected abstract String[] getConfigLocations();
	private BeanContext beanContext;
	private String[] args;
	public String[] getArgs() {
		return args;
	}
	public void setArgs(String[] args) {
		this.args = args;
	}
	public BeanContext getBeanContext(){
		return beanContext;
	}
	/**
	 * øApplication Ϣ
	 * @return
	 */
	public abstract T getApplicationConfig();
	
	@SuppressWarnings("unchecked")
	public <V extends Object> V createBean(Class<V> clazz) {
		return (V) getBeanFactory().autowire(clazz,
				AutowireCapableBeanFactory.AUTOWIRE_BY_NAME, false);
	}

	private AutowireCapableBeanFactory getBeanFactory(){
		if(factory == null){
			factory = context.getAutowireCapableBeanFactory();
		}
		
		return factory;
	}
	
	public void autowireBean(Object object) {
		getBeanFactory().autowireBeanProperties(object,
				AutowireCapableBeanFactory.AUTOWIRE_BY_NAME, false);
	}
	
	protected static void setUpSystemProperties(){
		File projectHome = new File(SystemPropertyUtils.resolvePlaceholders(System.getProperty("project.home",".")));
		System.setProperty("project.home",projectHome.getAbsolutePath());
		File projectOut = new File(SystemPropertyUtils.resolvePlaceholders(System.getProperty("project.output",".")));
		System.setProperty("project.output",projectOut.getAbsolutePath());
	}
	
	public void setUp() throws Exception {
		logger.warn(Application.this.getClass()+"  startup..");
		Runtime.getRuntime().addShutdownHook(new Thread(){
			public void run(){
				logger.warn(Application.this.getClass()+"  shutdown..");
			}
		});
		setUpSystemProperties();
		beanContext = new BeanContext(){
			public Object getBean(String beanName) {
				if(getBeanFactory() != null){
					return getBeanFactory().getBean(beanName);
				}else{
					return null;
				}
			}
			
			public Object createBean(Class clazz) throws Exception {
				if(getBeanFactory() instanceof AutowireCapableBeanFactory){
					AutowireCapableBeanFactory factory = (AutowireCapableBeanFactory)getBeanFactory();
					return factory.autowire(clazz, AutowireCapableBeanFactory.AUTOWIRE_BY_NAME, true);
				}
				return null;
			}
			
		};
		BeanContextBean.getInstance().setBeanContext(beanContext);
		BeanUtilsBean.setInstance(new BeanUtilsBean(new ConvertUtilsBean(),new PropertyUtilsBean()){
			@SuppressWarnings("unchecked")
			public void setProperty(Object bean, String name, Object value)throws IllegalAccessException, InvocationTargetException{
				if(value instanceof String){
					PropertyDescriptor descriptor = null;
		            try {
		                descriptor =
		                    getPropertyUtils().getPropertyDescriptor(bean, name);
		                if (descriptor == null) {
		                    return; // Skip this property setter
		                }else{
		                	if(descriptor.getPropertyType().isEnum()){
		                		Class<Enum> clazz = (Class<Enum>)descriptor.getPropertyType();
		                		value = Enum.valueOf(clazz,(String)value);
		                	}else{
		                		Object temp = null;
		                		try{
		                			temp = ConfigUtil.filter((String) value, beanContext);
		                		}catch(Exception e){
		                		}
		    					if(temp == null){
		    						temp = ConfigUtil.filter((String) value);
		    					}
		    					value = temp;
		                	}
		                }
		            } catch (NoSuchMethodException e) {
		                return; // Skip this property setter
		            }
				}
				super.setProperty(bean, name, value);
			}
			
		});
		
		if (getConfigLocations() != null && factory == null) {
			context = new ClassPathXmlApplicationContext(
					this.getConfigLocations(),false);
			context.refresh();
			if(this instanceof BeanFactoryAware){
				BeanFactoryAware aware = (BeanFactoryAware)this;
				aware.setBeanFactory(factory);
			}
			autowireBean(this);
		}
		
		if(getApplicationConfig() != null){
			getApplicationConfig().init();
		}
	}
	
	/**
	 * Ӧó
	 */
	public abstract void doRun();
	
	public void run(){
		try {
			String applicationName = System.getProperty("application.name",this.getClass().getSimpleName());
			/*ShutdownServer server = new ShutdownServer(applicationName);
			server.init();
			server.start();
			server.waitForRun();*/
			setUp();
		} catch (Exception e) {
			logger.error("init application error",e);
			
			//̨
			e.printStackTrace();
			System.exit(-1);
		}
		
		try {
			doRun();
		} catch (Exception e) {
			logger.error("run application error",e);
			
			//̨
			e.printStackTrace();
		}
	}
	
	public void runInContainer(){
		new Thread(){
			{
				this.setName(Application.this.getClass()+"_application");
				this.setDaemon(true);
			}
			public void run(){
				try {
					setUp();
					doRun();
				} catch (Exception e) {
					logger.error("run application error",e);
					//̨
					e.printStackTrace();
				}
			}
		}.start();
	}

	/**
	 * @param args
	 */
	@SuppressWarnings("unchecked")
	public static void main(String[] args) {
		String mainClass = (System.getProperty(ApplicationConfig.PROJECT_MAINCLASS));
		setUpSystemProperties();
		String log4jConf = System.getProperty("log4j.conf", "${project.home}/conf/log4j.xml");
        log4jConf = ConfigUtil.filter(log4jConf,System.getProperties());
        try {
			Log4jConfigurer.initLogging(log4jConf, FileWatchdog.DEFAULT_DELAY);
		} catch (FileNotFoundException e1) {
			String needLog4j = System.getProperty("log4j","false");
			if(Boolean.valueOf(needLog4j)){
				System.out.println("log4jConf not found:"+log4jConf+", system exit");
				System.exit(-1);
			}else{
				System.out.println("log4jConf not found:"+log4jConf);
			}
		}
		
		if(StringUtils.isEmpty(mainClass)){
			logger.error("application main class is null,pls set System property such as \"-D"+ApplicationConfig.PROJECT_MAINCLASS+"=mainClass\"");
			System.out.println("application main class is null,pls set System property such as \"-D"+ApplicationConfig.PROJECT_MAINCLASS+"=mainClass\"");
			System.exit(-1);
		}else{
			try {
				logger.info("starting run application with main class :"+mainClass);
				Application app = (Application)Class.forName(mainClass).newInstance();
				app.setArgs(args);
				app.run();
			} catch (Exception e) {
				logger.error("run application error with "+ mainClass,e);
				
				//̨
				e.printStackTrace();
			}
		}
	}
	
	

}
