package com.meidusa.toolkit.common.runtime;

import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ShutdownServer extends ShutdownRunner{
	
	private CountDownLatch latch = new CountDownLatch(1);
	public ShutdownServer(String appplicationName) {
		super(appplicationName);
	}

	public void waitForRun() throws Exception{
		latch.await(5,TimeUnit.SECONDS);
	}
	
	public void run() {
		Random random = new Random();
		InetAddress address = null;
		try {
			address = InetAddress.getLocalHost();
		} catch (UnknownHostException e1) {
			//System.exit(-1);
		}
		ServerSocket server = null;
		int times = 0;
		do{
		try {
			int port = random.nextInt(65535); 
			times ++;
			if(address != null){
				server = new ServerSocket(port,50,address);
			}else{
				server = new ServerSocket(port,50);
			}
			FileWriter writer = new FileWriter(socketInfoFile);
			writer.write(""+port);
			writer.flush();
			writer.close();
		} catch (IOException e) {
			if(times >100){
				System.out.println("cannot create shutdownServer socket,System exit now!");
				e.printStackTrace();
				System.exit(-1);
			}
		}
		}while(server == null);
		final ServerSocket finalServer = server;
		Runtime.getRuntime().addShutdownHook(new Thread(){
			public void run(){
				try {
					finalServer.close();
				} catch (IOException e) {
				}
			}
		});
		
		Runtime.getRuntime().addShutdownHook(new Thread(){
			public void run(){
				if(socketInfoFile.exists()){
					socketInfoFile.delete();
				}
			}
		});
		
		latch.countDown();
		while(true){
			try {
				final Socket socket = finalServer.accept();
				socket.setSoTimeout(1000);
				new Thread(){
					public void run(){
						try {
							ObjectInputStream is = new ObjectInputStream(socket.getInputStream());
							Command command = (Command)is.readObject();
							if(command == Command.SHUTDOWN){
								System.out.println("application shutdown now ...");
								ObjectOutputStream os = new ObjectOutputStream(socket.getOutputStream());
								os.writeObject(Command.OK);
								System.exit(0);
							}else if(command == Command.PING){
								ObjectOutputStream os = new ObjectOutputStream(socket.getOutputStream());
								os.writeObject(Command.PONG);
							}else{
								
							}
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				}.start();
			} catch (IOException e) {
			}
		}
		
	}
	
	public static void main(String[] args){
		ShutdownServer server = new ShutdownServer(Application.class.getSimpleName());
		server.init();
		server.start();
	}
}
