package com.meidusa.toolkit.common.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.util.SystemPropertyUtils;

import com.meidusa.toolkit.common.util.StringUtil;

public abstract class DefaultApplication<T extends ApplicationConfig> extends Application<T> {
	private static Logger logger = Logger.getLogger(DefaultApplication.class);
	@Override
	
	protected String[] getConfigLocations() {
		File file = new File(SystemPropertyUtils.resolvePlaceholders("${project.home}"),"conf");
		File springContextfile = new File(file,"springContext.properties");
		if(!springContextfile.exists()){
			logger.warn("file not Found :"+file.getAbsolutePath());
			return null;
		}
		List<String> configs = new ArrayList<String>();
		try {
			BufferedReader reader = new BufferedReader(new FileReader(springContextfile));
			String line = null;
			while((line = reader.readLine()) != null){
				line = line.trim();
				if(!StringUtil.isEmpty(line)){
					if(line.startsWith("#")){
						continue;
					}else{
						configs.add(line);
					}
				}
			}
			return configs.toArray(new String[]{});
		} catch (FileNotFoundException e) {
			logger.warn("file not Found",e);
			throw new RuntimeException("file not Found",e);
		} catch (IOException e) {
			logger.warn("IOException",e);
			throw new RuntimeException("IOException",e);
		}
	}

}
