package com.meidusa.toolkit.common.bean.type;
import java.lang.reflect.Type;

/**
 * Defines a generic object construction factory.  The purpose of this class
 * is to construct a default instance of a class that can be used for object
 * navigation while deserialization from its JSON representation.
 *
 * @author Inderjeet Singh
 * @author Joel Leitch
 */
public interface ObjectConstructor {

  /**
   * Creates a new instance of the given type.
   *
   * @param typeOfT the class type that should be instantiated
   * @return a default instance of the provided class.
   */
  public <T> T construct(Type typeOfT);

  /**
   * Constructs an array type of the provided length.
   *
   * @param typeOfArrayElements type of objects in the array
   * @param length size of the array
   * @return new array of size length
   */
  public Object constructArray(Type typeOfArrayElements, int length);
}