/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.dto;

import com.mangofactory.swagger.models.dto.AuthorizationScope;
import com.mangofactory.swagger.models.dto.AuthorizationType;
import com.mangofactory.swagger.models.dto.GrantType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class OAuth
extends AuthorizationType {
    private final List<AuthorizationScope> scopes;
    private final LinkedHashMap<String, GrantType> grantTypes;

    public OAuth(List<AuthorizationScope> scopes, List<GrantType> gTypes) {
        super("oauth2");
        this.scopes = scopes;
        this.grantTypes = this.initializeGrantTypes(gTypes);
    }

    private LinkedHashMap<String, GrantType> initializeGrantTypes(List<GrantType> gTypes) {
        if (null != gTypes) {
            LinkedHashMap<String, GrantType> map = new LinkedHashMap<String, GrantType>();
            for (GrantType grantType : gTypes) {
                map.put(grantType.getType(), grantType);
            }
            return map;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.type;
    }

    public List<AuthorizationScope> getScopes() {
        return this.scopes;
    }

    public List<GrantType> getGrantTypes() {
        return new ArrayList<GrantType>(this.grantTypes.values());
    }
}

