/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.mangofactory.swagger.models.dto.ContainerDataType;
import com.mangofactory.swagger.models.dto.PrimitiveDataType;
import com.mangofactory.swagger.models.dto.PrimitiveFormatDataType;
import com.mangofactory.swagger.models.dto.ReferenceDataType;
import com.mangofactory.swagger.models.dto.SwaggerDataType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataType
implements SwaggerDataType {
    @JsonUnwrapped
    @JsonProperty
    private final SwaggerDataType dataType;
    private static final Pattern containerPattern = Pattern.compile("([a-zA-Z]+)\\[([a-zA-Z\\.\\-]+)\\]");

    public DataType(String initialType) {
        this.dataType = this.typeFromDataType(initialType);
    }

    public SwaggerDataType typeFromDataType(String initialType) {
        if (this.isOfType(initialType, "void")) {
            return new PrimitiveDataType("void");
        }
        if (this.isOfType(initialType, "int")) {
            return new PrimitiveFormatDataType("integer", "int32");
        }
        if (this.isOfType(initialType, "long")) {
            return new PrimitiveFormatDataType("integer", "int64");
        }
        if (this.isOfType(initialType, "float")) {
            return new PrimitiveFormatDataType("integer", "int64");
        }
        if (this.isOfType(initialType, "double")) {
            return new PrimitiveFormatDataType("number", "double");
        }
        if (this.isOfType(initialType, "string")) {
            return new PrimitiveDataType("string");
        }
        if (this.isOfType(initialType, "byte")) {
            return new PrimitiveFormatDataType("string", "byte");
        }
        if (this.isOfType(initialType, "boolean")) {
            return new PrimitiveDataType("boolean");
        }
        if (this.isOfType(initialType, "Date") || this.isOfType(initialType, "DateTime")) {
            return new PrimitiveFormatDataType("string", "date-time");
        }
        if (this.isOfType(initialType, "BigDecimal") || this.isOfType(initialType, "BigInteger")) {
            return new PrimitiveDataType("number");
        }
        if (this.isOfType(initialType, "UUID")) {
            return new PrimitiveFormatDataType("string", "uuid");
        }
        if (this.isOfType(initialType, "date")) {
            return new PrimitiveFormatDataType("string", "date");
        }
        if (this.isOfType(initialType, "date-time")) {
            return new PrimitiveFormatDataType("string", "date-time");
        }
        Matcher matcher = containerPattern.matcher(initialType);
        if (matcher.matches()) {
            String containerInnerType = matcher.group(2);
            if (this.isUniqueContainerType(matcher.group(1))) {
                return new ContainerDataType(containerInnerType, true);
            }
            return new ContainerDataType(containerInnerType, false);
        }
        return new ReferenceDataType(initialType);
    }

    private boolean isUniqueContainerType(String containerInnerType) {
        return null != containerInnerType && containerInnerType.equalsIgnoreCase("Set");
    }

    private boolean isOfType(String initialType, String ofType) {
        return initialType.equals(ofType);
    }

    @Override
    public String getAbsoluteType() {
        return this.dataType.getAbsoluteType();
    }
}

