/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.config.ConfigHandler;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.Zipalign;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ZipalignMojo
extends AbstractAndroidMojo {
    @ConfigPojo
    private Zipalign zipalign;
    private Boolean zipalignSkip;
    @PullParameter(defaultValue="true")
    private Boolean parsedSkip;
    private Boolean zipalignVerbose;
    @PullParameter(defaultValue="false")
    private Boolean parsedVerbose;
    private String zipalignInputApk;
    @PullParameter(defaultValueGetterMethod="getInputApkPath")
    private String parsedInputApk;
    private String zipalignOutputApk;
    @PullParameter(defaultValueGetterMethod="getOutputApkPath")
    private String parsedOutputApk;
    private File apkFile;
    private File alignedApkFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!SUPPORTED_PACKAGING_TYPES.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Skipping zipalign on " + this.project.getPackaging()));
            return;
        }
        ConfigHandler configHandler = new ConfigHandler((Object)this);
        configHandler.parseConfiguration();
        this.getLog().debug((CharSequence)("skip:" + this.parsedSkip));
        this.getLog().debug((CharSequence)("verbose:" + this.parsedVerbose));
        this.getLog().debug((CharSequence)("inputApk:" + this.parsedInputApk));
        this.getLog().debug((CharSequence)("outputApk:" + this.parsedOutputApk));
        if (this.parsedSkip.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping zipalign");
        } else {
            CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
            executor.setLogger(this.getLog());
            String command = this.getAndroidSdk().getZipalignPath();
            ArrayList<String> parameters = new ArrayList<String>();
            if (this.parsedVerbose.booleanValue()) {
                parameters.add("-v");
            }
            parameters.add("-f");
            parameters.add("4");
            parameters.add(this.parsedInputApk);
            parameters.add(this.parsedOutputApk);
            try {
                this.getLog().info((CharSequence)("Running command: " + command));
                this.getLog().info((CharSequence)("with parameters: " + parameters));
                executor.executeCommand(command, parameters);
                File aligned = new File(this.parsedOutputApk);
                if (aligned.exists()) {
                    this.projectHelper.attachArtifact(this.project, "apk", "aligned", aligned);
                    this.getLog().info((CharSequence)("Attach " + aligned.getAbsolutePath() + " to the project"));
                } else {
                    this.getLog().error((CharSequence)("Cannot attach " + aligned.getAbsolutePath() + " to the project" + " - The file does not exist"));
                }
            }
            catch (ExecutionException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
    }

    private String getInputApkPath() {
        if (this.apkFile == null) {
            this.apkFile = new File(this.project.getBuild().getDirectory(), String.valueOf(this.project.getBuild().getFinalName()) + "." + "apk");
        }
        return this.apkFile.getAbsolutePath();
    }

    private String getOutputApkPath() {
        if (this.alignedApkFile == null) {
            this.alignedApkFile = new File(this.project.getBuild().getDirectory(), String.valueOf(this.project.getBuild().getFinalName()) + "-aligned." + "apk");
        }
        return this.alignedApkFile.getAbsolutePath();
    }
}

