/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.common.DeviceHelper;
import com.jayway.maven.plugins.android.common.LogSyncProgressMonitor;
import com.jayway.maven.plugins.android.config.ConfigHandler;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.Pull;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class PullMojo
extends AbstractAndroidMojo {
    @ConfigPojo
    private Pull pull;
    private String pullSource;
    @PullParameter(required=true)
    private String parsedSource;
    private String pullDestination;
    @PullParameter(required=true)
    private String parsedDestination;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ConfigHandler configHandler = new ConfigHandler((Object)this);
        configHandler.parseConfiguration();
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException {
                String message = "";
                try {
                    SyncService syncService = device.getSyncService();
                    FileListingService fileListingService = device.getFileListingService();
                    FileListingService.FileEntry sourceFileEntry = PullMojo.this.getFileEntry(PullMojo.this.parsedSource, fileListingService);
                    if (sourceFileEntry.isDirectory()) {
                        File destinationDir = new File(PullMojo.this.parsedDestination);
                        if (!destinationDir.exists()) {
                            PullMojo.this.getLog().info((CharSequence)("Creating destination directory " + destinationDir));
                            destinationDir.mkdirs();
                            destinationDir.mkdir();
                        }
                        String destinationDirPath = destinationDir.getAbsolutePath();
                        FileListingService.FileEntry[] fileEntries = PullMojo.this.parsedDestination.endsWith(File.separator) ? new FileListingService.FileEntry[]{sourceFileEntry} : fileListingService.getChildren(sourceFileEntry, true, null);
                        message = "Pull of " + PullMojo.this.parsedSource + " to " + destinationDirPath + " from ";
                        syncService.pull(fileEntries, destinationDirPath, (SyncService.ISyncProgressMonitor)new LogSyncProgressMonitor(PullMojo.this.getLog()));
                    } else {
                        File parentDir = new File(FilenameUtils.getFullPath((String)PullMojo.this.parsedDestination));
                        if (!parentDir.exists()) {
                            PullMojo.this.getLog().info((CharSequence)("Creating destination directory " + parentDir));
                            parentDir.mkdirs();
                        }
                        String destinationFileName = PullMojo.this.parsedDestination.endsWith(File.separator) ? FilenameUtils.getName((String)PullMojo.this.parsedSource) : FilenameUtils.getName((String)PullMojo.this.parsedDestination);
                        File destinationFile = new File(parentDir, destinationFileName);
                        String destinationFilePath = destinationFile.getAbsolutePath();
                        message = "Pull of " + PullMojo.this.parsedSource + " to " + destinationFilePath + " from " + DeviceHelper.getDescriptiveName(device);
                        syncService.pullFile(sourceFileEntry, destinationFilePath, (SyncService.ISyncProgressMonitor)new LogSyncProgressMonitor(PullMojo.this.getLog()));
                    }
                    PullMojo.this.getLog().info((CharSequence)(String.valueOf(message) + " successful."));
                }
                catch (SyncException e) {
                    throw new MojoExecutionException(String.valueOf(message) + " failed.", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(String.valueOf(message) + " failed.", (Exception)e);
                }
                catch (TimeoutException e) {
                    throw new MojoExecutionException(String.valueOf(message) + " failed.", (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    throw new MojoExecutionException(String.valueOf(message) + " failed.", (Exception)((Object)e));
                }
            }
        });
    }

    private FileListingService.FileEntry getFileEntry(String filePath, FileListingService fileListingService) throws MojoExecutionException {
        if (filePath.startsWith("/sdcard")) {
            filePath = "/mnt" + filePath;
        }
        String[] destinationPathSegments = StringUtils.split((String)filePath, (String)"/");
        FileListingService.FileEntry fileEntry = fileListingService.getRoot();
        String[] stringArray = destinationPathSegments;
        int n = destinationPathSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String destinationPathSegment = stringArray[n2];
            fileListingService.getChildren(fileEntry, true, null);
            fileEntry = fileEntry.findChild(destinationPathSegment);
            if (fileEntry == null) {
                throw new MojoExecutionException("Cannot execute goal: " + filePath + " does not exist on device.");
            }
            ++n2;
        }
        return fileEntry;
    }
}

