/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase08preparepackage;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.configuration.Emma;
import com.vladium.emma.instr.InstrProcessor;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class EmmaMojo
extends AbstractAndroidMojo {
    private static final String EMMA_FOLDER_NAME = "emma";
    private static final String CLASSES_FOLDER_NAME = "classes";
    private static final String COVERAGE_METADATA_NAME = "coverage.em";
    private Emma emma;
    private boolean emmaEnable;
    private String emmaClassFolders;
    private File emmaOutputMetaFile;
    private boolean parsedEnable;
    private String[] parsedEmmaClassFolders;
    private String parsedOutputMetadataFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Emma start working. Before parse configuration");
        this.parseConfiguration();
        if (this.parsedEnable) {
            this.getLog().info((CharSequence)"Emma OVERWRITE compiled class is on for this project! Do NOT use this project on production");
            this.getLog().debug((CharSequence)("configuration:  Class Folders - this file will be modified by emma " + this.parsedEmmaClassFolders));
            this.getLog().debug((CharSequence)("configuration:  parsedOutputMetadataFile " + this.parsedOutputMetadataFile));
            InstrProcessor processor = InstrProcessor.create();
            processor.setInstrPath(this.parsedEmmaClassFolders, true);
            processor.setInstrOutDir(this.parsedEmmaClassFolders[0]);
            processor.setMetaOutFile(this.parsedOutputMetadataFile);
            processor.setOutMode(InstrProcessor.OutMode.OUT_MODE_OVERWRITE);
            processor.setMetaOutMerge(Boolean.TRUE);
            processor.run();
        }
        this.getLog().debug((CharSequence)("Emma OVERWRITE is OFF for this project (" + this.project.getArtifactId() + ") target/classes files are safe"));
    }

    private void parseConfiguration() throws MojoExecutionException {
        if (this.emma != null) {
            this.parsedEnable = this.emma.isEnable() == null ? this.emmaEnable : this.emma.isEnable();
            this.parsedEmmaClassFolders = this.emma.getClassFolders() != null ? this.getAllCompiledDirectory() : this.getDefaultCompiledFolders();
            this.parsedOutputMetadataFile = this.emma.getOutputMetaFile() != null ? this.emma.getOutputMetaFile() : this.getDefaultMetaDataFile();
        } else {
            this.parsedEnable = this.emmaEnable;
            this.parsedEmmaClassFolders = new String[]{this.emmaClassFolders};
            this.parsedOutputMetadataFile = this.emmaOutputMetaFile.getAbsolutePath();
        }
    }

    private String getDefaultMetaDataFile() {
        File outputFolder = new File(String.valueOf(this.project.getBuild().getDirectory()) + File.separator + EMMA_FOLDER_NAME + File.separator + COVERAGE_METADATA_NAME);
        return outputFolder.getAbsolutePath();
    }

    private String[] getDefaultCompiledFolders() {
        File sourceJavaFolder = new File(String.valueOf(this.project.getBuild().getDirectory()) + File.separator + CLASSES_FOLDER_NAME + File.separator);
        return new String[]{sourceJavaFolder.getAbsolutePath()};
    }

    private String[] getAllCompiledDirectory() throws MojoExecutionException {
        String classFoldersTemp = this.emma.getClassFolders();
        if (classFoldersTemp == null) {
            return new String[]{this.emmaClassFolders};
        }
        String[] classFolders = classFoldersTemp.split(",");
        ArrayList<String> classFoldersArray = new ArrayList<String>();
        String[] stringArray = classFolders;
        int n = classFolders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            File directory = new File(folder);
            if (directory.exists() && directory.isDirectory()) {
                classFoldersArray.add(directory.getAbsolutePath());
            }
            ++n2;
        }
        return classFoldersArray.toArray(new String[0]);
    }
}

