/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase01generatesources;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.AetherHelper;
import com.jayway.maven.plugins.android.manifmerger.ManifestMerger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.AbstractScanner;

public class GenerateSourcesMojo
extends AbstractAndroidMojo {
    protected boolean mergeManifests;
    protected File genDirectory;
    protected File genDirectoryAidl;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isCurrentProjectAndroid()) {
            return;
        }
        try {
            this.extractSourceDependencies();
            this.extractApkLibDependencies();
            String[] relativeAidlFileNames1 = this.findRelativeAidlFileNames(this.sourceDirectory);
            String[] relativeAidlFileNames2 = this.findRelativeAidlFileNames(this.extractedDependenciesJavaSources);
            HashMap<String, String[]> relativeApklibAidlFileNames = new HashMap<String, String[]>();
            for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
                if (!artifact.getType().equals("apklib")) continue;
                String[] apklibAidlFiles = this.findRelativeAidlFileNames(new File(String.valueOf(this.getLibraryUnpackDirectory(artifact)) + "/src"));
                relativeApklibAidlFileNames.put(artifact.getArtifactId(), apklibAidlFiles);
            }
            this.mergeManifests();
            this.generateR();
            this.generateApklibR();
            this.generateBuildConfig();
            HashMap<File, String[]> files = new HashMap<File, String[]>();
            files.put(this.sourceDirectory, relativeAidlFileNames1);
            files.put(this.extractedDependenciesJavaSources, relativeAidlFileNames2);
            for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
                if (!artifact.getType().equals("apklib")) continue;
                files.put(new File(String.valueOf(this.getLibraryUnpackDirectory(artifact)) + "/src"), (String[])relativeApklibAidlFileNames.get(artifact.getArtifactId()));
            }
            this.generateAidlFiles(files);
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Error when generating sources.", (Throwable)e);
            throw e;
        }
    }

    protected void extractSourceDependencies() throws MojoExecutionException {
        for (Artifact artifact : this.getRelevantDependencyArtifacts()) {
            String type = artifact.getType();
            if (!type.equals("apksources")) continue;
            this.getLog().debug((CharSequence)("Detected apksources dependency " + artifact + " with file " + artifact.getFile() + ". Will resolve and extract..."));
            Artifact resolvedArtifact = AetherHelper.resolveArtifact(artifact, this.repoSystem, this.repoSession, this.projectRepos);
            File apksourcesFile = resolvedArtifact.getFile();
            if (!apksourcesFile.exists()) {
                apksourcesFile = this.resolveArtifactToFile(artifact);
            }
            if (apksourcesFile.isDirectory()) {
                apksourcesFile = this.resolveArtifactToFile(artifact);
            }
            this.getLog().debug((CharSequence)("Extracting " + apksourcesFile + "..."));
            this.extractApksources(apksourcesFile);
        }
        this.projectHelper.addResource(this.project, this.extractedDependenciesJavaResources.getAbsolutePath(), null, null);
        this.project.addCompileSourceRoot(this.extractedDependenciesJavaSources.getAbsolutePath());
    }

    private void extractApksources(File apksourcesFile) throws MojoExecutionException {
        if (apksourcesFile.isDirectory()) {
            this.getLog().warn((CharSequence)("The apksources artifact points to '" + apksourcesFile + "' which is a directory; skipping unpacking it."));
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(apksourcesFile){

            protected Logger getLogger() {
                return new ConsoleLogger(0, "dependencies-unarchiver");
            }
        };
        this.extractedDependenciesDirectory.mkdirs();
        unArchiver.setDestDirectory(this.extractedDependenciesDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + apksourcesFile.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private void extractApkLibDependencies() throws MojoExecutionException {
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String type = artifact.getType();
            if (!type.equals("apklib")) continue;
            this.getLog().debug((CharSequence)("Extracting apklib " + artifact.getArtifactId() + "..."));
            this.extractApklib(artifact);
        }
    }

    private void extractApklib(Artifact apklibArtifact) throws MojoExecutionException {
        Artifact resolvedArtifact = AetherHelper.resolveArtifact(apklibArtifact, this.repoSystem, this.repoSession, this.projectRepos);
        File apkLibFile = resolvedArtifact.getFile();
        if (!apkLibFile.exists()) {
            apkLibFile = this.resolveArtifactToFile(apklibArtifact);
        }
        if (apkLibFile.isDirectory()) {
            apkLibFile = this.resolveArtifactToFile(apklibArtifact);
        }
        if (apkLibFile.isDirectory()) {
            this.getLog().warn((CharSequence)("The apklib artifact points to '" + apkLibFile + "' which is a directory; skipping unpacking it."));
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(apkLibFile){

            protected Logger getLogger() {
                return new ConsoleLogger(0, "dependencies-unarchiver");
            }
        };
        File apklibDirectory = new File(this.getLibraryUnpackDirectory(apklibArtifact));
        apklibDirectory.mkdirs();
        unArchiver.setDestDirectory(apklibDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + apklibDirectory.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        this.projectHelper.addResource(this.project, String.valueOf(apklibDirectory.getAbsolutePath()) + "/src", null, Arrays.asList("**/*.java", "**/*.aidl"));
        this.project.addCompileSourceRoot(String.valueOf(apklibDirectory.getAbsolutePath()) + "/src");
    }

    private void generateR() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Generating R file for " + this.project.getPackaging()));
        this.genDirectory.mkdirs();
        File[] overlayDirectories = this.getResourceOverlayDirectories();
        if (this.extractedDependenciesRes.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying dependency resource files to combined resource directory.");
                if (!this.combinedRes.exists() && !this.combinedRes.mkdirs()) {
                    throw new MojoExecutionException("Could not create directory for combined resources at " + this.combinedRes.getAbsolutePath());
                }
                FileUtils.copyDirectory((File)this.extractedDependenciesRes, (File)this.combinedRes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        if (this.resourceDirectory.exists() && this.combinedRes.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying local resource files to combined resource directory.");
                FileUtils.copyDirectory((File)this.resourceDirectory, (File)this.combinedRes, (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String[] stringArray = AbstractScanner.DEFAULTEXCLUDES;
                        int n = AbstractScanner.DEFAULTEXCLUDES.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String pattern = stringArray[n2];
                            if (AbstractScanner.match((String)pattern, (String)file.getAbsolutePath())) {
                                GenerateSourcesMojo.this.getLog().debug((CharSequence)("Excluding " + file.getName() + " from resource copy : matching " + pattern));
                                return false;
                            }
                            ++n2;
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-m");
        commands.add("-J");
        commands.add(this.genDirectory.getAbsolutePath());
        commands.add("-M");
        commands.add(this.androidManifestFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.customPackage)) {
            commands.add("--custom-package");
            commands.add(this.customPackage);
        }
        this.addResourcesDirectories(commands, overlayDirectories);
        commands.add("--auto-add-overlay");
        if (this.assetsDirectory.exists()) {
            commands.add("-A");
            commands.add(this.assetsDirectory.getAbsolutePath());
        }
        if (this.extractedDependenciesAssets.exists()) {
            commands.add("-A");
            commands.add(this.extractedDependenciesAssets.getAbsolutePath());
        }
        commands.add("-I");
        commands.add(this.getAndroidSdk().getAndroidJar().getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        this.getLog().info((CharSequence)(String.valueOf(this.getAndroidSdk().getPathForTool("aapt")) + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("aapt"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        this.project.addCompileSourceRoot(this.genDirectory.getAbsolutePath());
    }

    private void addResourcesDirectories(List<String> commands, File[] overlayDirectories) {
        File[] fileArray = overlayDirectories;
        int n = overlayDirectories.length;
        int n2 = 0;
        while (n2 < n) {
            File resOverlayDir = fileArray[n2];
            if (resOverlayDir != null && resOverlayDir.exists()) {
                commands.add("-S");
                commands.add(resOverlayDir.getAbsolutePath());
            }
            ++n2;
        }
        if (this.combinedRes.exists()) {
            commands.add("-S");
            commands.add(this.combinedRes.getAbsolutePath());
        } else if (this.resourceDirectory.exists()) {
            commands.add("-S");
            commands.add(this.resourceDirectory.getAbsolutePath());
        }
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String apklibResDirectory;
            if (!artifact.getType().equals("apklib") || !new File(apklibResDirectory = String.valueOf(this.getLibraryUnpackDirectory(artifact)) + "/res").exists()) continue;
            commands.add("-S");
            commands.add(apklibResDirectory);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mergeManifests() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("mergeManifests: " + this.mergeManifests));
        if (!this.mergeManifests) {
            this.getLog().info((CharSequence)"Manifest merging disabled. Using project manifest only");
            return;
        }
        this.getLog().info((CharSequence)"Getting manifests of dependent apklibs");
        ArrayList<File> libManifests = new ArrayList<File>();
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            if (!artifact.getType().equals("apklib")) continue;
            File apklibManifeset = new File(this.getLibraryUnpackDirectory(artifact), "AndroidManifest.xml");
            if (!apklibManifeset.exists()) {
                throw new MojoExecutionException(String.valueOf(artifact.getArtifactId()) + " is missing AndroidManifest.xml");
            }
            libManifests.add(apklibManifeset);
        }
        if (libManifests.isEmpty()) {
            this.getLog().info((CharSequence)"No APKLIB manifests found. Using project manifest only.");
            return;
        }
        File mergedManifest = new File(this.androidManifestFile.getParent(), "AndroidManifest-merged.xml");
        ManifestMerger mm = new ManifestMerger(this.getLog(), this.getAndroidSdk().getSdkPath(), this.getAndroidSdk().getSdkMajorVersion());
        this.getLog().info((CharSequence)"Merging manifests of dependent apklibs");
        if (mm.process(mergedManifest, this.androidManifestFile, libManifests.toArray(new File[libManifests.size()]))) {
            this.androidManifestFile.delete();
            mergedManifest.renameTo(this.androidManifestFile);
            this.getLog().info((CharSequence)"Done Merging Manifests of APKLIBs");
            return;
        }
        this.getLog().error((CharSequence)"Manifests were not merged!");
        throw new MojoExecutionException("Manifests were not merged!");
    }

    private void generateApklibR() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating R file for projects dependent on apklibs");
        this.genDirectory.mkdirs();
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            if (!artifact.getType().equals("apklib")) continue;
            this.generateRForApkLibDependency(artifact);
        }
        this.project.addCompileSourceRoot(this.genDirectory.getAbsolutePath());
    }

    private void generateRForApkLibDependency(Artifact apklibArtifact) throws MojoExecutionException {
        String unpackDir = this.getLibraryUnpackDirectory(apklibArtifact);
        this.getLog().debug((CharSequence)("Generating R file for apklibrary: " + apklibArtifact.getGroupId()));
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-m");
        commands.add("-J");
        commands.add(this.genDirectory.getAbsolutePath());
        commands.add("--custom-package");
        commands.add(this.extractPackageNameFromAndroidManifest(new File(String.valueOf(unpackDir) + "/" + "AndroidManifest.xml")));
        commands.add("-M");
        commands.add(this.androidManifestFile.getAbsolutePath());
        if (this.resourceDirectory.exists()) {
            commands.add("-S");
            commands.add(this.resourceDirectory.getAbsolutePath());
        }
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String apkLibResDir;
            if (!artifact.getType().equals("apklib") || !new File(apkLibResDir = String.valueOf(this.getLibraryUnpackDirectory(artifact)) + "/res").exists()) continue;
            commands.add("-S");
            commands.add(apkLibResDir);
        }
        commands.add("--auto-add-overlay");
        if (this.assetsDirectory.exists()) {
            commands.add("-A");
            commands.add(this.assetsDirectory.getAbsolutePath());
        }
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String apkLibAssetsDir;
            if (!artifact.getType().equals("apklib") || !new File(apkLibAssetsDir = String.valueOf(this.getLibraryUnpackDirectory(artifact)) + "/assets").exists()) continue;
            commands.add("-A");
            commands.add(apkLibAssetsDir);
        }
        commands.add("-I");
        commands.add(this.getAndroidSdk().getAndroidJar().getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        this.getLog().info((CharSequence)(String.valueOf(this.getAndroidSdk().getPathForTool("aapt")) + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("aapt"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private void generateBuildConfig() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating BuildConfig file");
        String packageName = this.extractPackageNameFromAndroidManifest(this.androidManifestFile);
        if (StringUtils.isNotBlank((String)this.customPackage)) {
            packageName = this.customPackage;
        }
        this.generateBuildConfigForPackage(packageName, !this.release);
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            if (!artifact.getType().equals("apklib")) continue;
            File apklibManifeset = new File(this.getLibraryUnpackDirectory(artifact), "AndroidManifest.xml");
            String apklibPackageName = this.extractPackageNameFromAndroidManifest(apklibManifeset);
            this.generateBuildConfigForPackage(apklibPackageName, !this.release);
        }
    }

    private void generateBuildConfigForPackage(String packageName, boolean debug) throws MojoExecutionException {
        File outputFolder = new File(this.genDirectory, packageName.replace(".", File.separator));
        outputFolder.mkdirs();
        String buildConfig = "package " + packageName + ";\n\n" + "public final class BuildConfig {\n" + "  public static final boolean DEBUG = " + Boolean.toString(debug) + ";\n" + "}\n";
        File outputFile = new File(outputFolder, "BuildConfig.java");
        try {
            FileUtils.writeStringToFile((File)outputFile, (String)buildConfig);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error generating BuildConfig ", (Throwable)e);
            throw new MojoExecutionException("Error generating BuildConfig", (Exception)e);
        }
    }

    private void generateAidlFiles(Map<File, String[]> files) throws MojoExecutionException {
        ArrayList<String> protoCommands = new ArrayList<String>();
        protoCommands.add("-p" + this.getAndroidSdk().getPathForFrameworkAidl());
        this.genDirectoryAidl.mkdirs();
        this.project.addCompileSourceRoot(this.genDirectoryAidl.getPath());
        Set<File> sourceDirs = files.keySet();
        for (File sourceDir : sourceDirs) {
            protoCommands.add("-I" + sourceDir);
        }
        for (File sourceDir : sourceDirs) {
            String[] stringArray = files.get(sourceDir);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String relativeAidlFileName = stringArray[n2];
                File targetDirectory = new File(this.genDirectoryAidl, new File(relativeAidlFileName).getParent());
                targetDirectory.mkdirs();
                String shortAidlFileName = new File(relativeAidlFileName).getName();
                String shortJavaFileName = String.valueOf(shortAidlFileName.substring(0, shortAidlFileName.lastIndexOf("."))) + ".java";
                File aidlFileInSourceDirectory = new File(sourceDir, relativeAidlFileName);
                ArrayList<String> commands = new ArrayList<String>(protoCommands);
                commands.add(aidlFileInSourceDirectory.getAbsolutePath());
                commands.add(new File(targetDirectory, shortJavaFileName).getAbsolutePath());
                try {
                    CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
                    executor.setLogger(this.getLog());
                    executor.executeCommand(this.getAndroidSdk().getPathForTool("aidl"), commands, this.project.getBasedir(), false);
                }
                catch (ExecutionException e) {
                    throw new MojoExecutionException("", (Exception)e);
                }
                ++n2;
            }
        }
    }

    private String[] findRelativeAidlFileNames(File sourceDirectory) {
        String[] relativeAidlFileNames = this.findFilesInDirectory(sourceDirectory, "**/*.aidl");
        this.getLog().info((CharSequence)("ANDROID-904-002: Found aidl files: Count = " + relativeAidlFileNames.length));
        return relativeAidlFileNames;
    }

    private boolean isCurrentProjectAndroid() {
        HashSet<String> androidArtifacts = new HashSet<String>(){
            {
                this.addAll(Arrays.asList("apk", "apklib", "apksources"));
            }
        };
        return androidArtifacts.contains(this.project.getArtifact().getType());
    }
}

