/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.config;

import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public class ConfigHandler {
    private Object mojo;
    private Object configPojoInstance;
    private String configPojoName;
    private String configPojoPrefix;

    public ConfigHandler(Object mojo) {
        this.mojo = mojo;
        this.initConfigPojo();
    }

    private Collection<Field> findPropertiesByAnnotation(Class<? extends Annotation> annotation) {
        ArrayList<Field> result = new ArrayList<Field>();
        Field[] fieldArray = this.mojo.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(annotation)) {
                field.setAccessible(true);
                result.add(field);
            }
            ++n2;
        }
        return result;
    }

    public void parseConfiguration() {
        Collection<Field> parsedFields = this.findPropertiesByAnnotation(PullParameter.class);
        for (Field field : parsedFields) {
            Object propertyValue;
            Object value = null;
            String fieldBaseName = this.getFieldNameWithoutParsedPrefix(field);
            if (this.configPojoInstance != null) {
                value = this.getValueFromPojo(fieldBaseName);
            }
            if (!((propertyValue = this.getValueFromMojo(fieldBaseName)) == null || propertyValue instanceof Object[] && ((Object[])propertyValue).length == 0)) {
                value = propertyValue;
            }
            if (value == null) {
                value = this.getValueFromAnnotation(field);
            }
            try {
                field.set(this.mojo, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Object getValueFromAnnotation(Field field) {
        PullParameter annotation = field.getAnnotation(PullParameter.class);
        String defaultValue = annotation.defaultValue();
        boolean required = annotation.required();
        String currentParameterName = "android." + this.configPojoName + "." + this.getFieldNameWithoutParsedPrefix(field);
        if (!defaultValue.isEmpty()) {
            Class<Object> fieldType = field.getType();
            if (fieldType.isAssignableFrom(String.class)) {
                return defaultValue;
            }
            if (fieldType.isAssignableFrom(Boolean.class)) {
                return Boolean.valueOf(defaultValue);
            }
            throw new RuntimeException("No handler for type " + fieldType + " on " + currentParameterName + " found.");
        }
        if (!required) {
            try {
                Method method = this.mojo.getClass().getDeclaredMethod(annotation.defaultValueGetterMethod(), new Class[0]);
                method.setAccessible(true);
                return method.invoke(this.mojo, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Problem encountered accessing default value for " + currentParameterName + " parameter", e);
            }
        }
        throw new RuntimeException("Required parameter " + currentParameterName + " has no value. Please " + "supply with -D" + currentParameterName + "=value on the command line or as property or " + "plugin configuration in your pom or settings file.");
    }

    private Object getValueFromMojo(String fieldBaseName) {
        return this.getValueFromObject(this.mojo, String.valueOf(this.configPojoName) + this.toFirstLetterUppercase(fieldBaseName));
    }

    private Object getValueFromPojo(String fieldBaseName) {
        return this.getValueFromObject(this.configPojoInstance, fieldBaseName);
    }

    private Object getValueFromObject(Object object, String fieldBaseName) {
        try {
            Field pojoField = this.findFieldByName(object, fieldBaseName);
            if (pojoField != null) {
                return pojoField.get(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Field findFieldByName(Object object, String name) {
        Field[] fieldArray = object.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals(name)) {
                field.setAccessible(true);
                return field;
            }
            ++n2;
        }
        return null;
    }

    private String getFieldNameWithoutPrefix(Field field, String prefix) {
        if (field.getName().startsWith(prefix)) {
            String fieldName = field.getName().substring(prefix.length());
            return String.valueOf(fieldName.substring(0, 1).toLowerCase()) + fieldName.substring(1);
        }
        return field.getName();
    }

    private String toFirstLetterUppercase(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    private String getFieldNameWithoutParsedPrefix(Field field) {
        return this.getFieldNameWithoutPrefix(field, this.configPojoPrefix);
    }

    private void initConfigPojo() {
        try {
            Field configPojo = this.findPropertiesByAnnotation(ConfigPojo.class).iterator().next();
            this.configPojoName = configPojo.getName();
            this.configPojoInstance = configPojo.get(this.mojo);
            this.configPojoPrefix = configPojo.getAnnotation(ConfigPojo.class).prefix();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

