/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.IOUtil;

public class JarHelper {
    public static void unjar(JarFile jarFile, File outputDirectory, UnjarListener unjarListener) throws IOException {
        Enumeration<JarEntry> en = jarFile.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            File entryFile = new File(outputDirectory, entry.getName());
            if (!unjarListener.include(entry)) continue;
            if (!entryFile.getParentFile().exists() && !entryFile.getParentFile().mkdirs()) {
                throw new IOException("Error creating output directory: " + entryFile.getParentFile());
            }
            if (entry.isDirectory()) continue;
            InputStream in = jarFile.getInputStream(entry);
            try {
                FileOutputStream out = new FileOutputStream(entryFile);
                try {
                    IOUtil.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public static interface UnjarListener {
        public boolean include(JarEntry var1);
    }
}

