/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase04processclasses;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.AndroidExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class ProguardMojo
extends AbstractAndroidMojo {
    public static final String PROGUARD_OBFUSCATED_JAR = "proguard-obfuscated.jar";
    private static final String ANDROID_LIBRARY_FILTER = "!org/xml/**,!org/w3c/**,!org/apache/http/**,!java/**,!javax/**,!android/net/http/AndroidHttpClient.class";
    private String[] jvmArguments = new String[]{"Xmx256m"};
    private List<org.apache.maven.artifact.Artifact> artifactBlacklist = new LinkedList<org.apache.maven.artifact.Artifact>();
    private List<org.apache.maven.artifact.Artifact> artifactsToShift = new LinkedList<org.apache.maven.artifact.Artifact>();
    private List<ProGuardInput> inJars = new LinkedList<ProGuardInput>();
    private List<ProGuardInput> libraryJars = new LinkedList<ProGuardInput>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isProguardEnabled()) {
            this.executeProguard();
        }
    }

    private void executeProguard() throws MojoExecutionException {
        String proguardJar = this.getAndroidSdk().getPathForTool("proguard/lib/proguard.jar");
        File proguardDir = new File(this.project.getBuild().getDirectory(), "proguard");
        if (!proguardDir.exists() && !proguardDir.mkdir()) {
            throw new MojoExecutionException("Cannot create proguard output directory");
        }
        if (proguardDir.exists() && !proguardDir.isDirectory()) {
            throw new MojoExecutionException("Non-directory exists at " + proguardDir.getAbsolutePath());
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        this.collectJvmArguments(commands);
        commands.add("-jar");
        commands.add(proguardJar);
        commands.add("@" + this.proguard.getConfig());
        this.collectInputFiles(commands);
        commands.add("-outjars");
        commands.add(this.project.getBuild().getDirectory() + File.separator + PROGUARD_OBFUSCATED_JAR);
        commands.add("-dump");
        commands.add(proguardDir + File.separator + "dump.txt");
        commands.add("-printseeds");
        commands.add(proguardDir + File.separator + "seeds.txt");
        commands.add("-printusage");
        commands.add(proguardDir + File.separator + "usage.txt");
        commands.add("-printmapping");
        commands.add(proguardDir + File.separator + "mapping.txt");
        String javaExecutable = ProguardMojo.getJavaExecutable().getAbsolutePath();
        this.getLog().info((CharSequence)(javaExecutable + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(javaExecutable, commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private void collectJvmArguments(List<String> commands) {
        if (this.jvmArguments != null) {
            for (String jvmArgument : this.jvmArguments) {
                if (!jvmArgument.startsWith("-")) {
                    jvmArgument = "-" + jvmArgument;
                }
                commands.add(jvmArgument);
            }
        }
    }

    private void collectInputFiles(List<String> commands) {
        this.skipArtifact("commons-logging", "commons-logging", true);
        this.collectProgramInputFiles();
        for (ProGuardInput injar : this.inJars) {
            if (AndroidExtension.isAndroidPackaging(FileUtils.extension((String)injar.path))) continue;
            commands.add("-injars");
            commands.add(injar.toCommandLine());
        }
        this.collectLibraryInputFiles();
        for (ProGuardInput libraryjar : this.libraryJars) {
            commands.add("-libraryjars");
            commands.add(libraryjar.toCommandLine());
        }
    }

    private static File getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        String slash = File.separator;
        return new File(javaHome + slash + "bin" + slash + "java");
    }

    private void skipArtifact(String groupId, String artifactId, boolean shiftToLibraries) {
        this.artifactBlacklist.add(RepositoryUtils.toArtifact((Artifact)new DefaultArtifact(groupId, artifactId, null, null)));
        if (shiftToLibraries) {
            this.artifactsToShift.add(RepositoryUtils.toArtifact((Artifact)new DefaultArtifact(groupId, artifactId, null, null)));
        }
    }

    private boolean isBlacklistedArtifact(org.apache.maven.artifact.Artifact artifact) {
        for (org.apache.maven.artifact.Artifact artifactToSkip : this.artifactBlacklist) {
            if (!artifactToSkip.getGroupId().equals(artifact.getGroupId()) || !artifactToSkip.getArtifactId().equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private boolean isShiftedArtifact(org.apache.maven.artifact.Artifact artifact) {
        for (org.apache.maven.artifact.Artifact artifactToShift : this.artifactsToShift) {
            if (!artifactToShift.getGroupId().equals(artifact.getGroupId()) || !artifactToShift.getArtifactId().equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private void collectProgramInputFiles() {
        this.addInJar(this.project.getBuild().getOutputDirectory());
        for (org.apache.maven.artifact.Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            if (this.isBlacklistedArtifact(artifact)) continue;
            this.addInJar(artifact.getFile().getAbsolutePath());
        }
    }

    private void addInJar(String path, String filterExpression) {
        this.inJars.add(new ProGuardInput(path, filterExpression));
    }

    private void addInJar(String path) {
        this.addInJar(path, null);
    }

    private void addLibraryJar(String path, String filterExpression) {
        this.libraryJars.add(new ProGuardInput(path, filterExpression));
    }

    private void addLibraryJar(String path) {
        this.addLibraryJar(path, null);
    }

    private void collectLibraryInputFiles() {
        String slash = File.separator;
        String javaHome = System.getProperty("java.home");
        String jdkLibsPath = null;
        if (javaHome.startsWith("/System/Library/Java")) {
            jdkLibsPath = javaHome + "/../Classes";
            this.addLibraryJar(jdkLibsPath + "/classes.jar");
        } else {
            jdkLibsPath = javaHome + slash + "lib";
            this.addLibraryJar(jdkLibsPath + slash + "rt.jar");
        }
        this.addLibraryJar(jdkLibsPath + slash + "jsse.jar");
        this.addLibraryJar(jdkLibsPath + slash + "jce.jar");
        for (org.apache.maven.artifact.Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getScope().equals("provided")) {
                if (artifact.getArtifactId().equals("android")) {
                    this.addLibraryJar(artifact.getFile().getAbsolutePath(), ANDROID_LIBRARY_FILTER);
                    continue;
                }
                this.addLibraryJar(artifact.getFile().getAbsolutePath());
                continue;
            }
            if (!this.isShiftedArtifact(artifact)) continue;
            this.addLibraryJar(artifact.getFile().getAbsolutePath());
        }
    }

    private static class ProGuardInput {
        private String path;
        private String filterExpression;

        public ProGuardInput(String path, String filterExpression) {
            this.path = path;
            this.filterExpression = filterExpression;
        }

        public String toCommandLine() {
            if (this.filterExpression != null) {
                return this.path + "(" + this.filterExpression + ")";
            }
            return this.path;
        }
    }
}

