/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.List;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.MethodInvoker;
import org.beetl.core.om.ObjectAA;
import org.beetl.core.om.ObjectUtil;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IVarIndex;
import org.beetl.core.statement.Type;
import org.beetl.core.statement.VarAttribute;

public class VarRef
extends Expression
implements IVarIndex {
    public VarAttribute[] attributes;
    public Expression safe;
    public int varIndex;
    public boolean hasSafe;
    private GrammarToken firstToken = null;

    public VarRef(VarAttribute[] attributes, boolean hasSafe, Expression safe, GrammarToken token) {
        this(attributes, hasSafe, safe, token, token);
    }

    public VarRef(VarAttribute[] attributes, boolean hasSafe, Expression safe, GrammarToken token, GrammarToken firstToken) {
        super(token);
        this.attributes = attributes;
        this.safe = safe;
        this.hasSafe = hasSafe;
        this.firstToken = firstToken;
    }

    @Override
    public Object evaluate(Context ctx) {
        Result ret = this.getValue(ctx);
        if (ret.safe) {
            return ret.value;
        }
        Object value = ret.value;
        if (this.attributes.length == 0) {
            return value;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            VarAttribute attr = this.attributes[i];
            if (value == null) {
                if (this.hasSafe) {
                    return this.safe == null ? null : this.safe.evaluate(ctx);
                }
                BeetlException be = new BeetlException("NULL", "\u7a7a\u6307\u9488");
                if (i == 0) {
                    be.pushToken(this.firstToken);
                } else {
                    be.pushToken(this.attributes[i - 1].token);
                }
                throw be;
            }
            try {
                value = attr.evaluate(ctx, value);
                continue;
            }
            catch (BeetlException ex) {
                ex.pushToken(attr.token);
                throw ex;
            }
            catch (RuntimeException ex) {
                BeetlException be = new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex);
                be.pushToken(attr.token);
                throw be;
            }
        }
        if (value == null && this.hasSafe) {
            return this.safe == null ? null : this.safe.evaluate(ctx);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Result getValue(Context ctx) {
        Object object;
        Object value = ctx.vars[this.varIndex];
        if (value == Context.NOT_EXIST_OBJECT) {
            Object object2;
            if (ctx.globalVar != null && ctx.globalVar.containsKey("_root")) {
                Object root = ctx.getGlobal("_root");
                String attr = this.firstToken.text;
                if (root == null) {
                    Object object3;
                    if (!this.hasSafe) {
                        BeetlException be = new BeetlException("NULL", "_root\u4e3a\u7a7a\u6307\u9488\uff0c\u65e0" + this.firstToken.text + "\u503c");
                        be.pushToken(this.firstToken);
                        throw be;
                    }
                    if (this.safe == null) {
                        object3 = null;
                        return new Result(object3, true);
                    }
                    object3 = this.safe.evaluate(ctx);
                    return new Result(object3, true);
                }
                if (!this.hasAttr(root, attr)) {
                    BeetlException ex = new BeetlException("ATTRIBUTE_INVALID", "_root " + root.getClass() + " \u65e0\u6b64\u5c5e\u6027");
                    ex.pushToken(this.firstToken);
                    throw ex;
                }
                value = ObjectAA.defaultObjectAA().value(root, attr);
                if (value == null && this.hasSafe) {
                    Object object4;
                    if (this.safe == null) {
                        object4 = null;
                        return new Result(object4, true);
                    }
                    object4 = this.safe.evaluate(ctx);
                    return new Result(object4, true);
                }
                ctx.vars[this.varIndex] = value;
                return new Result(value);
            }
            if (!this.hasSafe) {
                BeetlException ex = new BeetlException("VAR_NOT_DEFINED");
                ex.pushToken(this.firstToken);
                throw ex;
            }
            if (this.safe == null) {
                object2 = null;
                return new Result(object2, true);
            }
            object2 = this.safe.evaluate(ctx);
            return new Result(object2, true);
        }
        if (value != null) return new Result(value);
        if (!this.hasSafe) return new Result(value);
        if (this.safe == null) {
            object = null;
            return new Result(object, true);
        }
        object = this.safe.evaluate(ctx);
        return new Result(object, true);
    }

    private boolean hasAttr(Object o, String attr) {
        if (o instanceof Map) {
            return true;
        }
        if (o instanceof List) {
            return false;
        }
        Class<?> c = o.getClass();
        MethodInvoker invoker = ObjectUtil.getInvokder(c, attr);
        return invoker != null;
    }

    public Object evaluateUntilLast(Context ctx) {
        if (this.attributes.length == 0) {
            throw new RuntimeException();
        }
        Result ret = this.getValue(ctx);
        Object value = ret.value;
        if (value == null) {
            BeetlException ex = new BeetlException("NULL");
            ex.pushToken(this.firstToken);
            throw ex;
        }
        for (int i = 0; i < this.attributes.length - 1; ++i) {
            VarAttribute attr = this.attributes[i];
            if (value == null) {
                BeetlException be = new BeetlException("NULL", "\u7a7a\u6307\u9488");
                if (i == 0) {
                    be.pushToken(this.firstToken);
                } else {
                    be.pushToken(this.attributes[i - 1].token);
                }
                throw be;
            }
            try {
                value = attr.evaluate(ctx, value);
                continue;
            }
            catch (BeetlException ex) {
                ex.pushToken(attr.token);
                throw ex;
            }
            catch (RuntimeException ex) {
                BeetlException be = new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex);
                be.pushToken(attr.token);
                throw be;
            }
        }
        return value;
    }

    @Override
    public void setVarIndex(int index) {
        this.varIndex = index;
    }

    @Override
    public int getVarIndex() {
        return this.varIndex;
    }

    @Override
    public void infer(InferContext inferCtx) {
        Type type;
        Type lastType = type = inferCtx.types[this.varIndex];
        Type t = null;
        for (VarAttribute attr : this.attributes) {
            inferCtx.temp = lastType;
            attr.infer(inferCtx);
            t = lastType;
            lastType = attr.type;
            attr.type = t;
        }
        this.type = lastType;
        if (this.safe != null) {
            this.safe.infer(inferCtx);
            if (!this.safe.type.equals(this.type)) {
                this.type = Type.ObjectType;
            }
        }
    }

    class Result {
        Object value;
        boolean safe = false;

        public Result(Object value, boolean safe) {
            this.value = value;
            this.safe = safe;
        }

        public Result(Object value) {
            this(value, false);
        }
    }
}

