/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "ln" locale.
 */
public class DateTimeFormatInfoImpl_ln extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatShort() {
    return "yy/MM/dd";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "libosó ya Y.-K.",
        "nsima ya Y.-K."
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "libosó ya Y.-K.",
        "nsima ya Y.-K."
    };
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "M/d/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "sánzá ya yambo",
        "sánzá ya míbalé",
        "sánzá ya mísáto",
        "sánzá ya mínei",
        "sánzá ya mítáno",
        "sánzá ya motóbá",
        "sánzá ya nsambo",
        "sánzá ya mwambe",
        "sánzá ya libwa",
        "sánzá ya zómi",
        "sánzá ya zómi na mɔ̌kɔ́",
        "sánzá ya zómi na míbalé"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
        "10",
        "11",
        "12"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "s1",
        "s2",
        "s3",
        "s4",
        "s5",
        "s6",
        "s7",
        "s8",
        "s9",
        "s10",
        "s11",
        "s12"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "sánzá mísáto ya yambo",
        "sánzá mísáto ya míbalé",
        "sánzá mísáto ya mísáto",
        "sánzá mísáto ya mínei"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "SM1",
        "SM2",
        "SM3",
        "SM4"
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "eyenga",
        "mokɔlɔ ya libosó",
        "mokɔlɔ ya míbalé",
        "mokɔlɔ ya mísáto",
        "mokɔlɔ ya mínéi",
        "mokɔlɔ ya mítáno",
        "mpɔ́sɔ"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "eye",
        "m1",
        "m2",
        "m3",
        "m4",
        "m5",
        "mps"
    };
  }
}
