/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/pipeline_job.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The runtime detail of a task execution.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskDetail}
 */
public final class PipelineTaskDetail extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineTaskDetail)
    PipelineTaskDetailOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PipelineTaskDetail.newBuilder() to construct.
  private PipelineTaskDetail(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PipelineTaskDetail() {
    taskName_ = "";
    state_ = 0;
    pipelineTaskStatus_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PipelineTaskDetail();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.Pipeline
        .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 10:
        return internalGetInputs();
      case 11:
        return internalGetOutputs();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.Pipeline
        .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.class,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies state of TaskExecution
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Specifies pending state for the task.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * Specifies task is being executed.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * Specifies task completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    SUCCEEDED(3),
    /**
     *
     *
     * <pre>
     * Specifies Task cancel is in pending state.
     * </pre>
     *
     * <code>CANCEL_PENDING = 4;</code>
     */
    CANCEL_PENDING(4),
    /**
     *
     *
     * <pre>
     * Specifies task is being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 5;</code>
     */
    CANCELLING(5),
    /**
     *
     *
     * <pre>
     * Specifies task was cancelled.
     * </pre>
     *
     * <code>CANCELLED = 6;</code>
     */
    CANCELLED(6),
    /**
     *
     *
     * <pre>
     * Specifies task failed.
     * </pre>
     *
     * <code>FAILED = 7;</code>
     */
    FAILED(7),
    /**
     *
     *
     * <pre>
     * Specifies task was skipped due to cache hit.
     * </pre>
     *
     * <code>SKIPPED = 8;</code>
     */
    SKIPPED(8),
    /**
     *
     *
     * <pre>
     * Specifies that the task was not triggered because the task's trigger
     * policy is not satisfied. The trigger policy is specified in the
     * `condition` field of
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
     * </pre>
     *
     * <code>NOT_TRIGGERED = 9;</code>
     */
    NOT_TRIGGERED(9),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Specifies pending state for the task.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Specifies task is being executed.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Specifies task completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    public static final int SUCCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Specifies Task cancel is in pending state.
     * </pre>
     *
     * <code>CANCEL_PENDING = 4;</code>
     */
    public static final int CANCEL_PENDING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Specifies task is being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 5;</code>
     */
    public static final int CANCELLING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Specifies task was cancelled.
     * </pre>
     *
     * <code>CANCELLED = 6;</code>
     */
    public static final int CANCELLED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Specifies task failed.
     * </pre>
     *
     * <code>FAILED = 7;</code>
     */
    public static final int FAILED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Specifies task was skipped due to cache hit.
     * </pre>
     *
     * <code>SKIPPED = 8;</code>
     */
    public static final int SKIPPED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Specifies that the task was not triggered because the task's trigger
     * policy is not satisfied. The trigger policy is specified in the
     * `condition` field of
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
     * </pre>
     *
     * <code>NOT_TRIGGERED = 9;</code>
     */
    public static final int NOT_TRIGGERED_VALUE = 9;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return RUNNING;
        case 3:
          return SUCCEEDED;
        case 4:
          return CANCEL_PENDING;
        case 5:
          return CANCELLING;
        case 6:
          return CANCELLED;
        case 7:
          return FAILED;
        case 8:
          return SKIPPED;
        case 9:
          return NOT_TRIGGERED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State)
  }

  public interface PipelineTaskStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Update time of this status.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    boolean hasUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. Update time of this status.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    com.google.protobuf.Timestamp getUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. Update time of this status.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. The state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State getState();

    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during the state. May be set when
     * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
     * FAILED state. If the state is FAILED, the error here is final and not
     * going to be retried. If the state is a non-final state, the error
     * indicates a system-error being retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    boolean hasError();
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during the state. May be set when
     * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
     * FAILED state. If the state is FAILED, the error here is final and not
     * going to be retried. If the state is a non-final state, the error
     * indicates a system-error being retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    com.google.rpc.Status getError();
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during the state. May be set when
     * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
     * FAILED state. If the state is FAILED, the error here is final and not
     * going to be retried. If the state is a non-final state, the error
     * indicates a system-error being retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    com.google.rpc.StatusOrBuilder getErrorOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A single record of the task status.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus}
   */
  public static final class PipelineTaskStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus)
      PipelineTaskStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PipelineTaskStatus.newBuilder() to construct.
    private PipelineTaskStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PipelineTaskStatus() {
      state_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PipelineTaskStatus();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_PipelineTaskStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_PipelineTaskStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.class,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder
                  .class);
    }

    private int bitField0_;
    public static final int UPDATE_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp updateTime_;
    /**
     *
     *
     * <pre>
     * Output only. Update time of this status.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this status.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getUpdateTime() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this status.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }

    public static final int STATE_FIELD_NUMBER = 2;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State getState() {
      com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State result =
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.forNumber(state_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.UNRECOGNIZED
          : result;
    }

    public static final int ERROR_FIELD_NUMBER = 3;
    private com.google.rpc.Status error_;
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during the state. May be set when
     * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
     * FAILED state. If the state is FAILED, the error here is final and not
     * going to be retried. If the state is a non-final state, the error
     * indicates a system-error being retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during the state. May be set when
     * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
     * FAILED state. If the state is FAILED, the error here is final and not
     * going to be retried. If the state is a non-final state, the error
     * indicates a system-error being retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    @java.lang.Override
    public com.google.rpc.Status getError() {
      return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during the state. May be set when
     * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
     * FAILED state. If the state is FAILED, the error here is final and not
     * going to be retried. If the state is a non-final state, the error
     * indicates a system-error being retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getUpdateTime());
      }
      if (state_
          != com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, state_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getError());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getUpdateTime());
      }
      if (state_
          != com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getError());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus other =
          (com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus) obj;

      if (hasUpdateTime() != other.hasUpdateTime()) return false;
      if (hasUpdateTime()) {
        if (!getUpdateTime().equals(other.getUpdateTime())) return false;
      }
      if (state_ != other.state_) return false;
      if (hasError() != other.hasError()) return false;
      if (hasError()) {
        if (!getError().equals(other.getError())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasUpdateTime()) {
        hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTime().hashCode();
      }
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      if (hasError()) {
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A single record of the task status.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus)
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_PipelineTaskStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_PipelineTaskStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.class,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getUpdateTimeFieldBuilder();
          getErrorFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        state_ = 0;
        error_ = null;
        if (errorBuilder_ != null) {
          errorBuilder_.dispose();
          errorBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_PipelineTaskStatus_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus build() {
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus result =
            new com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.updateTime_ =
              updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
                .getDefaultInstance()) return this;
        if (other.hasUpdateTime()) {
          mergeUpdateTime(other.getUpdateTime());
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp updateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          updateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Update time of this status.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the updateTime field is set.
       */
      public boolean hasUpdateTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Update time of this status.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The updateTime.
       */
      public com.google.protobuf.Timestamp getUpdateTime() {
        if (updateTimeBuilder_ == null) {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        } else {
          return updateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Update time of this status.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateTime_ = value;
        } else {
          updateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Update time of this status.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (updateTimeBuilder_ == null) {
          updateTime_ = builderForValue.build();
        } else {
          updateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Update time of this status.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && updateTime_ != null
              && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getUpdateTimeBuilder().mergeFrom(value);
          } else {
            updateTime_ = value;
          }
        } else {
          updateTimeBuilder_.mergeFrom(value);
        }
        if (updateTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Update time of this status.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Update time of this status.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Update time of this status.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
        if (updateTimeBuilder_ != null) {
          return updateTimeBuilder_.getMessageOrBuilder();
        } else {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Update time of this status.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getUpdateTimeFieldBuilder() {
        if (updateTimeBuilder_ == null) {
          updateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getUpdateTime(), getParentForChildren(), isClean());
          updateTime_ = null;
        }
        return updateTimeBuilder_;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. The state of the task.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the task.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the task.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State getState() {
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State result =
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.forNumber(state_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the task.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the task.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000002);
        state_ = 0;
        onChanged();
        return this;
      }

      private com.google.rpc.Status error_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          errorBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The error that occurred during the state. May be set when
       * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
       * FAILED state. If the state is FAILED, the error here is final and not
       * going to be retried. If the state is a non-final state, the error
       * indicates a system-error being retried.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the error field is set.
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The error that occurred during the state. May be set when
       * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
       * FAILED state. If the state is FAILED, the error here is final and not
       * going to be retried. If the state is a non-final state, the error
       * indicates a system-error being retried.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The error.
       */
      public com.google.rpc.Status getError() {
        if (errorBuilder_ == null) {
          return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The error that occurred during the state. May be set when
       * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
       * FAILED state. If the state is FAILED, the error here is final and not
       * going to be retried. If the state is a non-final state, the error
       * indicates a system-error being retried.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setError(com.google.rpc.Status value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The error that occurred during the state. May be set when
       * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
       * FAILED state. If the state is FAILED, the error here is final and not
       * going to be retried. If the state is a non-final state, the error
       * indicates a system-error being retried.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setError(com.google.rpc.Status.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The error that occurred during the state. May be set when
       * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
       * FAILED state. If the state is FAILED, the error here is final and not
       * going to be retried. If the state is a non-final state, the error
       * indicates a system-error being retried.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder mergeError(com.google.rpc.Status value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && error_ != null
              && error_ != com.google.rpc.Status.getDefaultInstance()) {
            getErrorBuilder().mergeFrom(value);
          } else {
            error_ = value;
          }
        } else {
          errorBuilder_.mergeFrom(value);
        }
        if (error_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The error that occurred during the state. May be set when
       * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
       * FAILED state. If the state is FAILED, the error here is final and not
       * going to be retried. If the state is a non-final state, the error
       * indicates a system-error being retried.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder clearError() {
        bitField0_ = (bitField0_ & ~0x00000004);
        error_ = null;
        if (errorBuilder_ != null) {
          errorBuilder_.dispose();
          errorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The error that occurred during the state. May be set when
       * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
       * FAILED state. If the state is FAILED, the error here is final and not
       * going to be retried. If the state is a non-final state, the error
       * indicates a system-error being retried.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.rpc.Status.Builder getErrorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The error that occurred during the state. May be set when
       * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
       * FAILED state. If the state is FAILED, the error here is final and not
       * going to be retried. If the state is a non-final state, the error
       * indicates a system-error being retried.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The error that occurred during the state. May be set when
       * the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
       * FAILED state. If the state is FAILED, the error here is final and not
       * going to be retried. If the state is a non-final state, the error
       * indicates a system-error being retried.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
          error_ = null;
        }
        return errorBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus)
    private static final com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus();
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PipelineTaskStatus> PARSER =
        new com.google.protobuf.AbstractParser<PipelineTaskStatus>() {
          @java.lang.Override
          public PipelineTaskStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PipelineTaskStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PipelineTaskStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ArtifactListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1beta1.Artifact> getArtifactsList();
    /**
     *
     *
     * <pre>
     * Output only. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.Artifact getArtifacts(int index);
    /**
     *
     *
     * <pre>
     * Output only. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getArtifactsCount();
    /**
     *
     *
     * <pre>
     * Output only. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ArtifactOrBuilder>
        getArtifactsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ArtifactOrBuilder getArtifactsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A list of artifact metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList}
   */
  public static final class ArtifactList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList)
      ArtifactListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ArtifactList.newBuilder() to construct.
    private ArtifactList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ArtifactList() {
      artifacts_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ArtifactList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_ArtifactList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_ArtifactList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.class,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder.class);
    }

    public static final int ARTIFACTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1beta1.Artifact> artifacts_;
    /**
     *
     *
     * <pre>
     * Output only. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Artifact> getArtifactsList() {
      return artifacts_;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ArtifactOrBuilder>
        getArtifactsOrBuilderList() {
      return artifacts_;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getArtifactsCount() {
      return artifacts_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Artifact getArtifacts(int index) {
      return artifacts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ArtifactOrBuilder getArtifactsOrBuilder(int index) {
      return artifacts_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < artifacts_.size(); i++) {
        output.writeMessage(1, artifacts_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < artifacts_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, artifacts_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList other =
          (com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) obj;

      if (!getArtifactsList().equals(other.getArtifactsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getArtifactsCount() > 0) {
        hash = (37 * hash) + ARTIFACTS_FIELD_NUMBER;
        hash = (53 * hash) + getArtifactsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A list of artifact metadata.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList)
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_ArtifactList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_ArtifactList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.class,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (artifactsBuilder_ == null) {
          artifacts_ = java.util.Collections.emptyList();
        } else {
          artifacts_ = null;
          artifactsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_ArtifactList_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList build() {
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList buildPartial() {
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList result =
            new com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList result) {
        if (artifactsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            artifacts_ = java.util.Collections.unmodifiableList(artifacts_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.artifacts_ = artifacts_;
        } else {
          result.artifacts_ = artifactsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
                .getDefaultInstance()) return this;
        if (artifactsBuilder_ == null) {
          if (!other.artifacts_.isEmpty()) {
            if (artifacts_.isEmpty()) {
              artifacts_ = other.artifacts_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureArtifactsIsMutable();
              artifacts_.addAll(other.artifacts_);
            }
            onChanged();
          }
        } else {
          if (!other.artifacts_.isEmpty()) {
            if (artifactsBuilder_.isEmpty()) {
              artifactsBuilder_.dispose();
              artifactsBuilder_ = null;
              artifacts_ = other.artifacts_;
              bitField0_ = (bitField0_ & ~0x00000001);
              artifactsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getArtifactsFieldBuilder()
                      : null;
            } else {
              artifactsBuilder_.addAllMessages(other.artifacts_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.aiplatform.v1beta1.Artifact m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.Artifact.parser(), extensionRegistry);
                  if (artifactsBuilder_ == null) {
                    ensureArtifactsIsMutable();
                    artifacts_.add(m);
                  } else {
                    artifactsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.aiplatform.v1beta1.Artifact> artifacts_ =
          java.util.Collections.emptyList();

      private void ensureArtifactsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          artifacts_ =
              new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Artifact>(artifacts_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.Artifact,
              com.google.cloud.aiplatform.v1beta1.Artifact.Builder,
              com.google.cloud.aiplatform.v1beta1.ArtifactOrBuilder>
          artifactsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.Artifact> getArtifactsList() {
        if (artifactsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(artifacts_);
        } else {
          return artifactsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getArtifactsCount() {
        if (artifactsBuilder_ == null) {
          return artifacts_.size();
        } else {
          return artifactsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.Artifact getArtifacts(int index) {
        if (artifactsBuilder_ == null) {
          return artifacts_.get(index);
        } else {
          return artifactsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setArtifacts(int index, com.google.cloud.aiplatform.v1beta1.Artifact value) {
        if (artifactsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArtifactsIsMutable();
          artifacts_.set(index, value);
          onChanged();
        } else {
          artifactsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setArtifacts(
          int index, com.google.cloud.aiplatform.v1beta1.Artifact.Builder builderForValue) {
        if (artifactsBuilder_ == null) {
          ensureArtifactsIsMutable();
          artifacts_.set(index, builderForValue.build());
          onChanged();
        } else {
          artifactsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addArtifacts(com.google.cloud.aiplatform.v1beta1.Artifact value) {
        if (artifactsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArtifactsIsMutable();
          artifacts_.add(value);
          onChanged();
        } else {
          artifactsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addArtifacts(int index, com.google.cloud.aiplatform.v1beta1.Artifact value) {
        if (artifactsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArtifactsIsMutable();
          artifacts_.add(index, value);
          onChanged();
        } else {
          artifactsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addArtifacts(
          com.google.cloud.aiplatform.v1beta1.Artifact.Builder builderForValue) {
        if (artifactsBuilder_ == null) {
          ensureArtifactsIsMutable();
          artifacts_.add(builderForValue.build());
          onChanged();
        } else {
          artifactsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addArtifacts(
          int index, com.google.cloud.aiplatform.v1beta1.Artifact.Builder builderForValue) {
        if (artifactsBuilder_ == null) {
          ensureArtifactsIsMutable();
          artifacts_.add(index, builderForValue.build());
          onChanged();
        } else {
          artifactsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllArtifacts(
          java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Artifact> values) {
        if (artifactsBuilder_ == null) {
          ensureArtifactsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, artifacts_);
          onChanged();
        } else {
          artifactsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearArtifacts() {
        if (artifactsBuilder_ == null) {
          artifacts_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          artifactsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeArtifacts(int index) {
        if (artifactsBuilder_ == null) {
          ensureArtifactsIsMutable();
          artifacts_.remove(index);
          onChanged();
        } else {
          artifactsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.Artifact.Builder getArtifactsBuilder(int index) {
        return getArtifactsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ArtifactOrBuilder getArtifactsOrBuilder(
          int index) {
        if (artifactsBuilder_ == null) {
          return artifacts_.get(index);
        } else {
          return artifactsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ArtifactOrBuilder>
          getArtifactsOrBuilderList() {
        if (artifactsBuilder_ != null) {
          return artifactsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(artifacts_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.Artifact.Builder addArtifactsBuilder() {
        return getArtifactsFieldBuilder()
            .addBuilder(com.google.cloud.aiplatform.v1beta1.Artifact.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.Artifact.Builder addArtifactsBuilder(int index) {
        return getArtifactsFieldBuilder()
            .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Artifact.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.Artifact artifacts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.Artifact.Builder>
          getArtifactsBuilderList() {
        return getArtifactsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.Artifact,
              com.google.cloud.aiplatform.v1beta1.Artifact.Builder,
              com.google.cloud.aiplatform.v1beta1.ArtifactOrBuilder>
          getArtifactsFieldBuilder() {
        if (artifactsBuilder_ == null) {
          artifactsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.Artifact,
                  com.google.cloud.aiplatform.v1beta1.Artifact.Builder,
                  com.google.cloud.aiplatform.v1beta1.ArtifactOrBuilder>(
                  artifacts_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          artifacts_ = null;
        }
        return artifactsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList)
    private static final com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList();
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ArtifactList> PARSER =
        new com.google.protobuf.AbstractParser<ArtifactList>() {
          @java.lang.Override
          public ArtifactList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ArtifactList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ArtifactList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TASK_ID_FIELD_NUMBER = 1;
  private long taskId_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The system generated ID of the task.
   * </pre>
   *
   * <code>int64 task_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The taskId.
   */
  @java.lang.Override
  public long getTaskId() {
    return taskId_;
  }

  public static final int PARENT_TASK_ID_FIELD_NUMBER = 12;
  private long parentTaskId_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The id of the parent task if the task is within a component
   * scope. Empty if the task is at the root level.
   * </pre>
   *
   * <code>int64 parent_task_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The parentTaskId.
   */
  @java.lang.Override
  public long getParentTaskId() {
    return parentTaskId_;
  }

  public static final int TASK_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object taskName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The user specified name of the task that is defined in
   * [pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
   * </pre>
   *
   * <code>string task_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The taskName.
   */
  @java.lang.Override
  public java.lang.String getTaskName() {
    java.lang.Object ref = taskName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      taskName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The user specified name of the task that is defined in
   * [pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
   * </pre>
   *
   * <code>string task_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for taskName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTaskNameBytes() {
    java.lang.Object ref = taskName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      taskName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Task create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Task create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Task create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Task start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Task start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Task start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Task end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Task end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Task end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int EXECUTOR_DETAIL_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executorDetail_;
  /**
   *
   *
   * <pre>
   * Output only. The detailed execution info.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the executorDetail field is set.
   */
  @java.lang.Override
  public boolean hasExecutorDetail() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed execution info.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The executorDetail.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail getExecutorDetail() {
    return executorDetail_ == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.getDefaultInstance()
        : executorDetail_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed execution info.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetailOrBuilder
      getExecutorDetailOrBuilder() {
    return executorDetail_ == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.getDefaultInstance()
        : executorDetail_;
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the task.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the task.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State getState() {
    com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State result =
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.forNumber(state_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.UNRECOGNIZED
        : result;
  }

  public static final int EXECUTION_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.Execution execution_;
  /**
   *
   *
   * <pre>
   * Output only. The execution metadata of the task.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the execution field is set.
   */
  @java.lang.Override
  public boolean hasExecution() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The execution metadata of the task.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The execution.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Execution getExecution() {
    return execution_ == null
        ? com.google.cloud.aiplatform.v1beta1.Execution.getDefaultInstance()
        : execution_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The execution metadata of the task.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExecutionOrBuilder getExecutionOrBuilder() {
    return execution_ == null
        ? com.google.cloud.aiplatform.v1beta1.Execution.getDefaultInstance()
        : execution_;
  }

  public static final int ERROR_FIELD_NUMBER = 9;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during task execution.
   * Only populated when the task's state is FAILED or CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during task execution.
   * Only populated when the task's state is FAILED or CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during task execution.
   * Only populated when the task's state is FAILED or CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int PIPELINE_TASK_STATUS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus>
      pipelineTaskStatus_;
  /**
   *
   *
   * <pre>
   * Output only. A list of task status. This field keeps a record of task
   * status evolving over time.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus>
      getPipelineTaskStatusList() {
    return pipelineTaskStatus_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of task status. This field keeps a record of task
   * status evolving over time.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatusOrBuilder>
      getPipelineTaskStatusOrBuilderList() {
    return pipelineTaskStatus_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of task status. This field keeps a record of task
   * status evolving over time.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getPipelineTaskStatusCount() {
    return pipelineTaskStatus_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of task status. This field keeps a record of task
   * status evolving over time.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
      getPipelineTaskStatus(int index) {
    return pipelineTaskStatus_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of task status. This field keeps a record of task
   * status evolving over time.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatusOrBuilder
      getPipelineTaskStatusOrBuilder(int index) {
    return pipelineTaskStatus_.get(index);
  }

  public static final int INPUTS_FIELD_NUMBER = 10;

  private static final class InputsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
                    newDefaultInstance(
                        com.google.cloud.aiplatform.v1beta1.Pipeline
                            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_InputsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
      inputs_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
      internalGetInputs() {
    if (inputs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(InputsDefaultEntryHolder.defaultEntry);
    }
    return inputs_;
  }

  public int getInputsCount() {
    return internalGetInputs().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The runtime input artifacts of the task.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsInputs(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetInputs().getMap().containsKey(key);
  }
  /** Use {@link #getInputsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
      getInputs() {
    return getInputsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. The runtime input artifacts of the task.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
      getInputsMap() {
    return internalGetInputs().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. The runtime input artifacts of the task.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
      getInputsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        map = internalGetInputs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. The runtime input artifacts of the task.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList getInputsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        map = internalGetInputs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int OUTPUTS_FIELD_NUMBER = 11;

  private static final class OutputsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
                    newDefaultInstance(
                        com.google.cloud.aiplatform.v1beta1.Pipeline
                            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_OutputsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
      outputs_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
      internalGetOutputs() {
    if (outputs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(OutputsDefaultEntryHolder.defaultEntry);
    }
    return outputs_;
  }

  public int getOutputsCount() {
    return internalGetOutputs().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The runtime output artifacts of the task.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsOutputs(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetOutputs().getMap().containsKey(key);
  }
  /** Use {@link #getOutputsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
      getOutputs() {
    return getOutputsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. The runtime output artifacts of the task.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
      getOutputsMap() {
    return internalGetOutputs().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. The runtime output artifacts of the task.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
      getOutputsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        map = internalGetOutputs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. The runtime output artifacts of the task.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList getOutputsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        map = internalGetOutputs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (taskId_ != 0L) {
      output.writeInt64(1, taskId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(taskName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, taskName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getEndTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getExecutorDetail());
    }
    if (state_
        != com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, state_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(8, getExecution());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(9, getError());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetInputs(), InputsDefaultEntryHolder.defaultEntry, 10);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetOutputs(), OutputsDefaultEntryHolder.defaultEntry, 11);
    if (parentTaskId_ != 0L) {
      output.writeInt64(12, parentTaskId_);
    }
    for (int i = 0; i < pipelineTaskStatus_.size(); i++) {
      output.writeMessage(13, pipelineTaskStatus_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (taskId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, taskId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(taskName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, taskName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getExecutorDetail());
    }
    if (state_
        != com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getExecution());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getError());
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        entry : internalGetInputs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
          inputs__ =
              InputsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, inputs__);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        entry : internalGetOutputs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
          outputs__ =
              OutputsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, outputs__);
    }
    if (parentTaskId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(12, parentTaskId_);
    }
    for (int i = 0; i < pipelineTaskStatus_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, pipelineTaskStatus_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail other =
        (com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail) obj;

    if (getTaskId() != other.getTaskId()) return false;
    if (getParentTaskId() != other.getParentTaskId()) return false;
    if (!getTaskName().equals(other.getTaskName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasExecutorDetail() != other.hasExecutorDetail()) return false;
    if (hasExecutorDetail()) {
      if (!getExecutorDetail().equals(other.getExecutorDetail())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasExecution() != other.hasExecution()) return false;
    if (hasExecution()) {
      if (!getExecution().equals(other.getExecution())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getPipelineTaskStatusList().equals(other.getPipelineTaskStatusList())) return false;
    if (!internalGetInputs().equals(other.internalGetInputs())) return false;
    if (!internalGetOutputs().equals(other.internalGetOutputs())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TASK_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTaskId());
    hash = (37 * hash) + PARENT_TASK_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getParentTaskId());
    hash = (37 * hash) + TASK_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTaskName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasExecutorDetail()) {
      hash = (37 * hash) + EXECUTOR_DETAIL_FIELD_NUMBER;
      hash = (53 * hash) + getExecutorDetail().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasExecution()) {
      hash = (37 * hash) + EXECUTION_FIELD_NUMBER;
      hash = (53 * hash) + getExecution().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (getPipelineTaskStatusCount() > 0) {
      hash = (37 * hash) + PIPELINE_TASK_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getPipelineTaskStatusList().hashCode();
    }
    if (!internalGetInputs().getMap().isEmpty()) {
      hash = (37 * hash) + INPUTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetInputs().hashCode();
    }
    if (!internalGetOutputs().getMap().isEmpty()) {
      hash = (37 * hash) + OUTPUTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetOutputs().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The runtime detail of a task execution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskDetail}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineTaskDetail)
      com.google.cloud.aiplatform.v1beta1.PipelineTaskDetailOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetInputs();
        case 11:
          return internalGetOutputs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetMutableInputs();
        case 11:
          return internalGetMutableOutputs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.class,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getExecutorDetailFieldBuilder();
        getExecutionFieldBuilder();
        getErrorFieldBuilder();
        getPipelineTaskStatusFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      taskId_ = 0L;
      parentTaskId_ = 0L;
      taskName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      executorDetail_ = null;
      if (executorDetailBuilder_ != null) {
        executorDetailBuilder_.dispose();
        executorDetailBuilder_ = null;
      }
      state_ = 0;
      execution_ = null;
      if (executionBuilder_ != null) {
        executionBuilder_.dispose();
        executionBuilder_ = null;
      }
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      if (pipelineTaskStatusBuilder_ == null) {
        pipelineTaskStatus_ = java.util.Collections.emptyList();
      } else {
        pipelineTaskStatus_ = null;
        pipelineTaskStatusBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      internalGetMutableInputs().clear();
      internalGetMutableOutputs().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskDetail_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail build() {
      com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail result =
          new com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail result) {
      if (pipelineTaskStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          pipelineTaskStatus_ = java.util.Collections.unmodifiableList(pipelineTaskStatus_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.pipelineTaskStatus_ = pipelineTaskStatus_;
      } else {
        result.pipelineTaskStatus_ = pipelineTaskStatusBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.taskId_ = taskId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parentTaskId_ = parentTaskId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.taskName_ = taskName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.executorDetail_ =
            executorDetailBuilder_ == null ? executorDetail_ : executorDetailBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.execution_ = executionBuilder_ == null ? execution_ : executionBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.inputs_ = internalGetInputs().build(InputsDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.outputs_ = internalGetOutputs().build(OutputsDefaultEntryHolder.defaultEntry);
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.getDefaultInstance())
        return this;
      if (other.getTaskId() != 0L) {
        setTaskId(other.getTaskId());
      }
      if (other.getParentTaskId() != 0L) {
        setParentTaskId(other.getParentTaskId());
      }
      if (!other.getTaskName().isEmpty()) {
        taskName_ = other.taskName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasExecutorDetail()) {
        mergeExecutorDetail(other.getExecutorDetail());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasExecution()) {
        mergeExecution(other.getExecution());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (pipelineTaskStatusBuilder_ == null) {
        if (!other.pipelineTaskStatus_.isEmpty()) {
          if (pipelineTaskStatus_.isEmpty()) {
            pipelineTaskStatus_ = other.pipelineTaskStatus_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensurePipelineTaskStatusIsMutable();
            pipelineTaskStatus_.addAll(other.pipelineTaskStatus_);
          }
          onChanged();
        }
      } else {
        if (!other.pipelineTaskStatus_.isEmpty()) {
          if (pipelineTaskStatusBuilder_.isEmpty()) {
            pipelineTaskStatusBuilder_.dispose();
            pipelineTaskStatusBuilder_ = null;
            pipelineTaskStatus_ = other.pipelineTaskStatus_;
            bitField0_ = (bitField0_ & ~0x00000400);
            pipelineTaskStatusBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPipelineTaskStatusFieldBuilder()
                    : null;
          } else {
            pipelineTaskStatusBuilder_.addAllMessages(other.pipelineTaskStatus_);
          }
        }
      }
      internalGetMutableInputs().mergeFrom(other.internalGetInputs());
      bitField0_ |= 0x00000800;
      internalGetMutableOutputs().mergeFrom(other.internalGetOutputs());
      bitField0_ |= 0x00001000;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                taskId_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                taskName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getExecutorDetailFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 56:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getExecutionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
                    inputs__ =
                        input.readMessage(
                            InputsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableInputs()
                    .ensureBuilderMap()
                    .put(inputs__.getKey(), inputs__.getValue());
                bitField0_ |= 0x00000800;
                break;
              } // case 82
            case 90:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
                    outputs__ =
                        input.readMessage(
                            OutputsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableOutputs()
                    .ensureBuilderMap()
                    .put(outputs__.getKey(), outputs__.getValue());
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 96:
              {
                parentTaskId_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 96
            case 106:
              {
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
                            .parser(),
                        extensionRegistry);
                if (pipelineTaskStatusBuilder_ == null) {
                  ensurePipelineTaskStatusIsMutable();
                  pipelineTaskStatus_.add(m);
                } else {
                  pipelineTaskStatusBuilder_.addMessage(m);
                }
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long taskId_;
    /**
     *
     *
     * <pre>
     * Output only. The system generated ID of the task.
     * </pre>
     *
     * <code>int64 task_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The taskId.
     */
    @java.lang.Override
    public long getTaskId() {
      return taskId_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The system generated ID of the task.
     * </pre>
     *
     * <code>int64 task_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The taskId to set.
     * @return This builder for chaining.
     */
    public Builder setTaskId(long value) {

      taskId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The system generated ID of the task.
     * </pre>
     *
     * <code>int64 task_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTaskId() {
      bitField0_ = (bitField0_ & ~0x00000001);
      taskId_ = 0L;
      onChanged();
      return this;
    }

    private long parentTaskId_;
    /**
     *
     *
     * <pre>
     * Output only. The id of the parent task if the task is within a component
     * scope. Empty if the task is at the root level.
     * </pre>
     *
     * <code>int64 parent_task_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The parentTaskId.
     */
    @java.lang.Override
    public long getParentTaskId() {
      return parentTaskId_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The id of the parent task if the task is within a component
     * scope. Empty if the task is at the root level.
     * </pre>
     *
     * <code>int64 parent_task_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The parentTaskId to set.
     * @return This builder for chaining.
     */
    public Builder setParentTaskId(long value) {

      parentTaskId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The id of the parent task if the task is within a component
     * scope. Empty if the task is at the root level.
     * </pre>
     *
     * <code>int64 parent_task_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentTaskId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      parentTaskId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object taskName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The user specified name of the task that is defined in
     * [pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
     * </pre>
     *
     * <code>string task_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The taskName.
     */
    public java.lang.String getTaskName() {
      java.lang.Object ref = taskName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        taskName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The user specified name of the task that is defined in
     * [pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
     * </pre>
     *
     * <code>string task_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for taskName.
     */
    public com.google.protobuf.ByteString getTaskNameBytes() {
      java.lang.Object ref = taskName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        taskName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The user specified name of the task that is defined in
     * [pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
     * </pre>
     *
     * <code>string task_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The taskName to set.
     * @return This builder for chaining.
     */
    public Builder setTaskName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      taskName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user specified name of the task that is defined in
     * [pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
     * </pre>
     *
     * <code>string task_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTaskName() {
      taskName_ = getDefaultInstance().getTaskName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user specified name of the task that is defined in
     * [pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
     * </pre>
     *
     * <code>string task_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for taskName to set.
     * @return This builder for chaining.
     */
    public Builder setTaskNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      taskName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Task create time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Task create time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Task create time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task create time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task create time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task create time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task create time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Task create time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Task create time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Task start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Task start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Task start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Task start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Task start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Task end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Task end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Task end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Task end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Task end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Task end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executorDetail_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetailOrBuilder>
        executorDetailBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The detailed execution info.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the executorDetail field is set.
     */
    public boolean hasExecutorDetail() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed execution info.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The executorDetail.
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail getExecutorDetail() {
      if (executorDetailBuilder_ == null) {
        return executorDetail_ == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.getDefaultInstance()
            : executorDetail_;
      } else {
        return executorDetailBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed execution info.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExecutorDetail(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail value) {
      if (executorDetailBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        executorDetail_ = value;
      } else {
        executorDetailBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed execution info.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExecutorDetail(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.Builder builderForValue) {
      if (executorDetailBuilder_ == null) {
        executorDetail_ = builderForValue.build();
      } else {
        executorDetailBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed execution info.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExecutorDetail(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail value) {
      if (executorDetailBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && executorDetail_ != null
            && executorDetail_
                != com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail
                    .getDefaultInstance()) {
          getExecutorDetailBuilder().mergeFrom(value);
        } else {
          executorDetail_ = value;
        }
      } else {
        executorDetailBuilder_.mergeFrom(value);
      }
      if (executorDetail_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed execution info.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExecutorDetail() {
      bitField0_ = (bitField0_ & ~0x00000040);
      executorDetail_ = null;
      if (executorDetailBuilder_ != null) {
        executorDetailBuilder_.dispose();
        executorDetailBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed execution info.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.Builder
        getExecutorDetailBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getExecutorDetailFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed execution info.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetailOrBuilder
        getExecutorDetailOrBuilder() {
      if (executorDetailBuilder_ != null) {
        return executorDetailBuilder_.getMessageOrBuilder();
      } else {
        return executorDetail_ == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.getDefaultInstance()
            : executorDetail_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed execution info.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail executor_detail = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetailOrBuilder>
        getExecutorDetailFieldBuilder() {
      if (executorDetailBuilder_ == null) {
        executorDetailBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.Builder,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetailOrBuilder>(
                getExecutorDetail(), getParentForChildren(), isClean());
        executorDetail_ = null;
      }
      return executorDetailBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State getState() {
      com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State result =
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.forNumber(state_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.Execution execution_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Execution,
            com.google.cloud.aiplatform.v1beta1.Execution.Builder,
            com.google.cloud.aiplatform.v1beta1.ExecutionOrBuilder>
        executionBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The execution metadata of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the execution field is set.
     */
    public boolean hasExecution() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The execution metadata of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The execution.
     */
    public com.google.cloud.aiplatform.v1beta1.Execution getExecution() {
      if (executionBuilder_ == null) {
        return execution_ == null
            ? com.google.cloud.aiplatform.v1beta1.Execution.getDefaultInstance()
            : execution_;
      } else {
        return executionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The execution metadata of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExecution(com.google.cloud.aiplatform.v1beta1.Execution value) {
      if (executionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        execution_ = value;
      } else {
        executionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The execution metadata of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExecution(
        com.google.cloud.aiplatform.v1beta1.Execution.Builder builderForValue) {
      if (executionBuilder_ == null) {
        execution_ = builderForValue.build();
      } else {
        executionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The execution metadata of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExecution(com.google.cloud.aiplatform.v1beta1.Execution value) {
      if (executionBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && execution_ != null
            && execution_ != com.google.cloud.aiplatform.v1beta1.Execution.getDefaultInstance()) {
          getExecutionBuilder().mergeFrom(value);
        } else {
          execution_ = value;
        }
      } else {
        executionBuilder_.mergeFrom(value);
      }
      if (execution_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The execution metadata of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExecution() {
      bitField0_ = (bitField0_ & ~0x00000100);
      execution_ = null;
      if (executionBuilder_ != null) {
        executionBuilder_.dispose();
        executionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The execution metadata of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Execution.Builder getExecutionBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getExecutionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The execution metadata of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExecutionOrBuilder getExecutionOrBuilder() {
      if (executionBuilder_ != null) {
        return executionBuilder_.getMessageOrBuilder();
      } else {
        return execution_ == null
            ? com.google.cloud.aiplatform.v1beta1.Execution.getDefaultInstance()
            : execution_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The execution metadata of the task.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Execution execution = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Execution,
            com.google.cloud.aiplatform.v1beta1.Execution.Builder,
            com.google.cloud.aiplatform.v1beta1.ExecutionOrBuilder>
        getExecutionFieldBuilder() {
      if (executionBuilder_ == null) {
        executionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Execution,
                com.google.cloud.aiplatform.v1beta1.Execution.Builder,
                com.google.cloud.aiplatform.v1beta1.ExecutionOrBuilder>(
                getExecution(), getParentForChildren(), isClean());
        execution_ = null;
      }
      return executionBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during task execution.
     * Only populated when the task's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during task execution.
     * Only populated when the task's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during task execution.
     * Only populated when the task's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during task execution.
     * Only populated when the task's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during task execution.
     * Only populated when the task's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during task execution.
     * Only populated when the task's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000200);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during task execution.
     * Only populated when the task's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during task execution.
     * Only populated when the task's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during task execution.
     * Only populated when the task's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus>
        pipelineTaskStatus_ = java.util.Collections.emptyList();

    private void ensurePipelineTaskStatusIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        pipelineTaskStatus_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus>(
                pipelineTaskStatus_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatusOrBuilder>
        pipelineTaskStatusBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus>
        getPipelineTaskStatusList() {
      if (pipelineTaskStatusBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pipelineTaskStatus_);
      } else {
        return pipelineTaskStatusBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getPipelineTaskStatusCount() {
      if (pipelineTaskStatusBuilder_ == null) {
        return pipelineTaskStatus_.size();
      } else {
        return pipelineTaskStatusBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
        getPipelineTaskStatus(int index) {
      if (pipelineTaskStatusBuilder_ == null) {
        return pipelineTaskStatus_.get(index);
      } else {
        return pipelineTaskStatusBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPipelineTaskStatus(
        int index,
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus value) {
      if (pipelineTaskStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePipelineTaskStatusIsMutable();
        pipelineTaskStatus_.set(index, value);
        onChanged();
      } else {
        pipelineTaskStatusBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPipelineTaskStatus(
        int index,
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder
            builderForValue) {
      if (pipelineTaskStatusBuilder_ == null) {
        ensurePipelineTaskStatusIsMutable();
        pipelineTaskStatus_.set(index, builderForValue.build());
        onChanged();
      } else {
        pipelineTaskStatusBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPipelineTaskStatus(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus value) {
      if (pipelineTaskStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePipelineTaskStatusIsMutable();
        pipelineTaskStatus_.add(value);
        onChanged();
      } else {
        pipelineTaskStatusBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPipelineTaskStatus(
        int index,
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus value) {
      if (pipelineTaskStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePipelineTaskStatusIsMutable();
        pipelineTaskStatus_.add(index, value);
        onChanged();
      } else {
        pipelineTaskStatusBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPipelineTaskStatus(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder
            builderForValue) {
      if (pipelineTaskStatusBuilder_ == null) {
        ensurePipelineTaskStatusIsMutable();
        pipelineTaskStatus_.add(builderForValue.build());
        onChanged();
      } else {
        pipelineTaskStatusBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPipelineTaskStatus(
        int index,
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder
            builderForValue) {
      if (pipelineTaskStatusBuilder_ == null) {
        ensurePipelineTaskStatusIsMutable();
        pipelineTaskStatus_.add(index, builderForValue.build());
        onChanged();
      } else {
        pipelineTaskStatusBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllPipelineTaskStatus(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus>
            values) {
      if (pipelineTaskStatusBuilder_ == null) {
        ensurePipelineTaskStatusIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pipelineTaskStatus_);
        onChanged();
      } else {
        pipelineTaskStatusBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPipelineTaskStatus() {
      if (pipelineTaskStatusBuilder_ == null) {
        pipelineTaskStatus_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        pipelineTaskStatusBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removePipelineTaskStatus(int index) {
      if (pipelineTaskStatusBuilder_ == null) {
        ensurePipelineTaskStatusIsMutable();
        pipelineTaskStatus_.remove(index);
        onChanged();
      } else {
        pipelineTaskStatusBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder
        getPipelineTaskStatusBuilder(int index) {
      return getPipelineTaskStatusFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatusOrBuilder
        getPipelineTaskStatusOrBuilder(int index) {
      if (pipelineTaskStatusBuilder_ == null) {
        return pipelineTaskStatus_.get(index);
      } else {
        return pipelineTaskStatusBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatusOrBuilder>
        getPipelineTaskStatusOrBuilderList() {
      if (pipelineTaskStatusBuilder_ != null) {
        return pipelineTaskStatusBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pipelineTaskStatus_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder
        addPipelineTaskStatusBuilder() {
      return getPipelineTaskStatusFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder
        addPipelineTaskStatusBuilder(int index) {
      return getPipelineTaskStatusFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of task status. This field keeps a record of task
     * status evolving over time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus pipeline_task_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder>
        getPipelineTaskStatusBuilderList() {
      return getPipelineTaskStatusFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatusOrBuilder>
        getPipelineTaskStatusFieldBuilder() {
      if (pipelineTaskStatusBuilder_ == null) {
        pipelineTaskStatusBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.Builder,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatusOrBuilder>(
                pipelineTaskStatus_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        pipelineTaskStatus_ = null;
      }
      return pipelineTaskStatusBuilder_;
    }

    private static final class InputsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList> {
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList build(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder val) {
        if (val instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) {
          return (com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) val;
        }
        return ((com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder) val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
          defaultEntry() {
        return InputsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final InputsConverter inputsConverter = new InputsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder>
        inputs_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder>
        internalGetInputs() {
      if (inputs_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(inputsConverter);
      }
      return inputs_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder>
        internalGetMutableInputs() {
      if (inputs_ == null) {
        inputs_ = new com.google.protobuf.MapFieldBuilder<>(inputsConverter);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return inputs_;
    }

    public int getInputsCount() {
      return internalGetInputs().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime input artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsInputs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetInputs().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getInputsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        getInputs() {
      return getInputsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime input artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        getInputsMap() {
      return internalGetInputs().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime input artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
        getInputsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder>
          map = internalGetMutableInputs().ensureBuilderMap();
      return map.containsKey(key) ? inputsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime input artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList getInputsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder>
          map = internalGetMutableInputs().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return inputsConverter.build(map.get(key));
    }

    public Builder clearInputs() {
      bitField0_ = (bitField0_ & ~0x00000800);
      internalGetMutableInputs().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime input artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeInputs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableInputs().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        getMutableInputs() {
      bitField0_ |= 0x00000800;
      return internalGetMutableInputs().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime input artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putInputs(
        java.lang.String key,
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableInputs().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000800;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime input artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllInputs(
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableInputs().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000800;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime input artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; inputs = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder
        putInputsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder>
          builderMap = internalGetMutableInputs().ensureBuilderMap();
      com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) {
        entry =
            ((com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) entry)
                .toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder) entry;
    }

    private static final class OutputsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList> {
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList build(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder val) {
        if (val instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) {
          return (com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) val;
        }
        return ((com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder) val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
          defaultEntry() {
        return OutputsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final OutputsConverter outputsConverter = new OutputsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder>
        outputs_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder>
        internalGetOutputs() {
      if (outputs_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(outputsConverter);
      }
      return outputs_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder>
        internalGetMutableOutputs() {
      if (outputs_ == null) {
        outputs_ = new com.google.protobuf.MapFieldBuilder<>(outputsConverter);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return outputs_;
    }

    public int getOutputsCount() {
      return internalGetOutputs().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime output artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsOutputs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetOutputs().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getOutputsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        getOutputs() {
      return getOutputsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime output artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        getOutputsMap() {
      return internalGetOutputs().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime output artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
        getOutputsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder>
          map = internalGetMutableOutputs().ensureBuilderMap();
      return map.containsKey(key) ? outputsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime output artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList getOutputsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder>
          map = internalGetMutableOutputs().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return outputsConverter.build(map.get(key));
    }

    public Builder clearOutputs() {
      bitField0_ = (bitField0_ & ~0x00001000);
      internalGetMutableOutputs().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime output artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeOutputs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableOutputs().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
        getMutableOutputs() {
      bitField0_ |= 0x00001000;
      return internalGetMutableOutputs().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime output artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putOutputs(
        java.lang.String key,
        com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableOutputs().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00001000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime output artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllOutputs(
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableOutputs().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00001000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The runtime output artifacts of the task.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList&gt; outputs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder
        putOutputsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder>
          builderMap = internalGetMutableOutputs().ensureBuilderMap();
      com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactListOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) {
        entry =
            ((com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList) entry)
                .toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.Builder) entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineTaskDetail)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineTaskDetail)
  private static final com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail();
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PipelineTaskDetail> PARSER =
      new com.google.protobuf.AbstractParser<PipelineTaskDetail>() {
        @java.lang.Override
        public PipelineTaskDetail parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PipelineTaskDetail> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PipelineTaskDetail> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskDetail getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
