/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.runner.AbstractSpecRunnerHtmlGenerator;
import com.github.searls.jasmine.runner.HtmlGeneratorConfiguration;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSpecRunnerHtmlGenerator
extends AbstractSpecRunnerHtmlGenerator
implements SpecRunnerHtmlGenerator {
    public static final String DEFAULT_RUNNER_HTML_TEMPLATE_FILE = "/jasmine-templates/SpecRunner.htmltemplate";

    protected DefaultSpecRunnerHtmlGenerator(HtmlGeneratorConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String generate() {
        try {
            return this.generateHtml(this.getConfiguration().getAllScripts());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load files for dependencies, sources, or a custom runner", e);
        }
    }

    @Override
    public String generateWitRelativePaths() {
        try {
            Set<String> allScriptsRelativePath = this.getConfiguration().getAllScriptsRelativePath();
            return this.generateHtml(allScriptsRelativePath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load files for dependencies, sources, or a custom runner", e);
        }
    }

    private String generateHtml(Set<String> allScriptsRelativePath) throws IOException {
        StringTemplate template = this.resolveHtmlTemplate();
        this.includeJavaScriptDependencies(Arrays.asList("/vendor/js/jasmine.js", "/vendor/js/jasmine-html.js"), template);
        this.applyCssToTemplate(Arrays.asList("/vendor/css/jasmine.css"), template);
        this.applyScriptTagsToTemplate("sources", allScriptsRelativePath, template);
        template.setAttribute("reporter", (Object)this.getConfiguration().getReporterType().name());
        this.setEncoding(this.getConfiguration(), template);
        return template.toString();
    }

    @Override
    protected String getDefaultHtmlTemplatePath() {
        return DEFAULT_RUNNER_HTML_TEMPLATE_FILE;
    }
}

