/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.io.scripts;

import com.github.searls.jasmine.io.scripts.FindsScriptLocationsInDirectory;
import com.github.searls.jasmine.io.scripts.RelativizesASetOfScripts;
import com.github.searls.jasmine.io.scripts.ResolvesLocationOfPreloadSources;
import com.github.searls.jasmine.model.ScriptSearch;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvesCompleteListOfScriptLocations {
    private FindsScriptLocationsInDirectory findsScriptLocationsInDirectory = new FindsScriptLocationsInDirectory();
    private ResolvesLocationOfPreloadSources resolvesLocationOfPreloadSources = new ResolvesLocationOfPreloadSources();
    private RelativizesASetOfScripts relativizesASetOfScripts = new RelativizesASetOfScripts();
    private Set<String> preloadScripts;
    private Set<String> sources;
    private Set<String> specs;
    private Set<String> allScripts;

    public Set<String> resolve(ScriptSearch sources, ScriptSearch specs, List<String> preloadSources) throws IOException {
        this.preloadScripts = new LinkedHashSet<String>(this.resolvesLocationOfPreloadSources.resolve(preloadSources, sources.getDirectory(), specs.getDirectory()));
        this.sources = new LinkedHashSet<String>(this.findsScriptLocationsInDirectory.find(sources));
        this.specs = new LinkedHashSet<String>(this.findsScriptLocationsInDirectory.find(specs));
        this.allScripts = new LinkedHashSet<String>();
        this.allScripts.addAll(this.preloadScripts);
        this.allScripts.addAll(this.sources);
        this.allScripts.addAll(this.specs);
        return this.allScripts;
    }

    public Set<String> getPreloadScripts() {
        return this.preloadScripts;
    }

    public Set<String> getSources() {
        return this.sources;
    }

    public Set<String> getSpecs() {
        return this.specs;
    }

    public Set<String> getAllScripts() {
        return this.allScripts;
    }
}

