/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.spring.namespace.parser;

import com.dangdang.ddframe.rdb.sharding.config.common.api.config.BindingTableRuleConfig;
import com.dangdang.ddframe.rdb.sharding.config.common.api.config.GenerateKeyColumnConfig;
import com.dangdang.ddframe.rdb.sharding.config.common.api.config.ShardingRuleConfig;
import com.dangdang.ddframe.rdb.sharding.config.common.api.config.TableRuleConfig;
import com.dangdang.ddframe.rdb.sharding.spring.datasource.SpringShardingDataSource;
import com.dangdang.ddframe.rdb.sharding.spring.namespace.parser.ShardingJdbcStrategyBeanDefinition;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ShardingJdbcDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringShardingDataSource.class);
        factory.addConstructorArgValue((Object)this.parseShardingRuleConfig(element, parserContext));
        factory.addConstructorArgValue((Object)this.parseProperties(element, parserContext));
        factory.setDestroyMethodName("close");
        return factory.getBeanDefinition();
    }

    private BeanDefinition parseShardingRuleConfig(Element element, ParserContext parserContext) {
        Element shardingRuleElement = DomUtils.getChildElementByTagName((Element)element, (String)"sharding-rule");
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ShardingRuleConfig.class);
        factory.addPropertyValue("dataSource", this.parseDataSources(shardingRuleElement, parserContext));
        this.parseDefaultDataSource(factory, shardingRuleElement);
        factory.addPropertyValue("tables", this.parseTableRulesConfig(shardingRuleElement));
        factory.addPropertyValue("bindingTables", this.parseBindingTablesConfig(shardingRuleElement));
        factory.addPropertyValue("defaultDatabaseStrategy", (Object)this.parseDefaultDatabaseStrategyConfig(shardingRuleElement));
        factory.addPropertyValue("defaultTableStrategy", (Object)this.parseDefaultTableStrategyConfig(shardingRuleElement));
        this.parseKeyGenerator(factory, shardingRuleElement);
        return factory.getBeanDefinition();
    }

    private void parseKeyGenerator(BeanDefinitionBuilder factory, Element element) {
        String keyGeneratorClass = element.getAttribute("key-generator-class");
        if (!Strings.isNullOrEmpty((String)keyGeneratorClass)) {
            factory.addPropertyValue("keyGeneratorClass", (Object)keyGeneratorClass);
        }
    }

    private Map<String, BeanDefinition> parseDataSources(Element element, ParserContext parserContext) {
        List dataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("data-sources"));
        ManagedMap result = new ManagedMap(dataSources.size());
        for (String each : dataSources) {
            result.put(each, parserContext.getRegistry().getBeanDefinition(each));
        }
        return result;
    }

    private void parseDefaultDataSource(BeanDefinitionBuilder factory, Element element) {
        String defaultDataSource = element.getAttribute("default-data-source");
        if (!Strings.isNullOrEmpty((String)defaultDataSource)) {
            factory.addPropertyValue("defaultDataSourceName", (Object)defaultDataSource);
        }
    }

    private Map<String, BeanDefinition> parseTableRulesConfig(Element element) {
        Element tableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"table-rules");
        List tableRuleElements = DomUtils.getChildElementsByTagName((Element)tableRulesElement, (String)"table-rule");
        ManagedMap result = new ManagedMap(tableRuleElements.size());
        for (Element each : tableRuleElements) {
            result.put(each.getAttribute("logic-table"), this.parseTableRuleConfig(each));
        }
        return result;
    }

    private BeanDefinition parseTableRuleConfig(Element tableElement) {
        List generateKeyColumns;
        String tableStrategy;
        String databaseStrategy;
        String dataSourceNames;
        String actualTables;
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(TableRuleConfig.class);
        String dynamic = tableElement.getAttribute("dynamic");
        if (!Strings.isNullOrEmpty((String)dynamic)) {
            factory.addPropertyValue("dynamic", (Object)dynamic);
        }
        if (!Strings.isNullOrEmpty((String)(actualTables = tableElement.getAttribute("actual-tables")))) {
            factory.addPropertyValue("actualTables", (Object)actualTables);
        }
        if (!Strings.isNullOrEmpty((String)(dataSourceNames = tableElement.getAttribute("data-source-names")))) {
            factory.addPropertyValue("dataSourceNames", (Object)dataSourceNames);
        }
        if (!Strings.isNullOrEmpty((String)(databaseStrategy = tableElement.getAttribute("database-strategy")))) {
            factory.addPropertyReference("databaseStrategy", databaseStrategy);
        }
        if (!Strings.isNullOrEmpty((String)(tableStrategy = tableElement.getAttribute("table-strategy")))) {
            factory.addPropertyReference("tableStrategy", tableStrategy);
        }
        if (null == (generateKeyColumns = DomUtils.getChildElementsByTagName((Element)tableElement, (String)"generate-key-column")) || generateKeyColumns.isEmpty()) {
            return factory.getBeanDefinition();
        }
        factory.addPropertyValue("generateKeyColumns", (Object)Lists.transform((List)generateKeyColumns, (Function)new Function<Element, GenerateKeyColumnConfig>(){

            public GenerateKeyColumnConfig apply(Element input) {
                GenerateKeyColumnConfig result = new GenerateKeyColumnConfig();
                result.setColumnName(input.getAttribute("column-name"));
                result.setColumnKeyGeneratorClass(input.getAttribute("column-key-generator-class"));
                return result;
            }
        }));
        return factory.getBeanDefinition();
    }

    private List<BeanDefinition> parseBindingTablesConfig(Element element) {
        Element bindingTableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"binding-table-rules");
        if (null == bindingTableRulesElement) {
            return Collections.emptyList();
        }
        List bindingTableRuleElements = DomUtils.getChildElementsByTagName((Element)bindingTableRulesElement, (String)"binding-table-rule");
        BeanDefinitionBuilder bindingTableRuleFactory = BeanDefinitionBuilder.rootBeanDefinition(BindingTableRuleConfig.class);
        ManagedList result = new ManagedList(bindingTableRuleElements.size());
        for (Element bindingTableRuleElement : bindingTableRuleElements) {
            bindingTableRuleFactory.addPropertyValue("tableNames", (Object)bindingTableRuleElement.getAttribute("logic-tables"));
            result.add(bindingTableRuleFactory.getBeanDefinition());
        }
        return result;
    }

    private BeanDefinition parseDefaultDatabaseStrategyConfig(Element element) {
        return this.parseDefaultStrategyConfig(element, "default-database-strategy");
    }

    private BeanDefinition parseDefaultTableStrategyConfig(Element element) {
        return this.parseDefaultStrategyConfig(element, "default-table-strategy");
    }

    private BeanDefinition parseDefaultStrategyConfig(Element element, String attr) {
        Element strategyElement = DomUtils.getChildElementByTagName((Element)element, (String)attr);
        return null == strategyElement ? null : ShardingJdbcStrategyBeanDefinition.getBeanDefinitionByElement(strategyElement);
    }

    private Properties parseProperties(Element element, ParserContext parserContext) {
        Element propsElement = DomUtils.getChildElementByTagName((Element)element, (String)"props");
        return null == propsElement ? new Properties() : parserContext.getDelegate().parsePropsElement(propsElement);
    }
}

