/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Page<T>
implements IPage<T>,
Serializable {
    private static final long serialVersionUID = 8545996863226528798L;
    private List<T> records = Collections.emptyList();
    private Long total = 0L;
    private long size = 10L;
    private long current = 1L;
    private List<String> ascs;
    private List<String> descs;

    public Page() {
    }

    public Page(long current, long size) {
        this(current, size, 0L);
    }

    public Page(long current, long size, Long total) {
        if (current > 1L) {
            this.current = current;
        }
        this.size = size;
        this.total = total;
    }

    public boolean hasPrevious() {
        return this.current > 1L;
    }

    public boolean hasNext() {
        return this.current < this.getPages();
    }

    public List<T> getRecords() {
        return this.records;
    }

    public IPage<T> setRecords(List<T> records) {
        this.records = records;
        return this;
    }

    public Page<T> setTotal(Long total) {
        this.total = total;
        return this;
    }

    public Long getTotal() {
        return this.total;
    }

    public Page<T> setSize(long size) {
        this.size = size;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public Page<T> setCurrent(long current) {
        this.current = current;
        return this;
    }

    public long getCurrent() {
        return this.current;
    }

    public List<String> ascs() {
        return this.ascs;
    }

    public Page<T> setAscs(List<String> ascs) {
        this.ascs = ascs;
        return this;
    }

    public Page<T> setAscs(String ... ascs) {
        if (ArrayUtils.isNotEmpty((Object[])ascs)) {
            this.ascs = Arrays.asList(ascs);
        }
        return this;
    }

    public List<String> descs() {
        return this.descs;
    }

    public Page<T> setDescs(List<String> descs) {
        this.descs = descs;
        return this;
    }

    public Page<T> setDescs(String ... descs) {
        if (ArrayUtils.isNotEmpty((Object[])descs)) {
            this.descs = Arrays.asList(descs);
        }
        return this;
    }
}

