/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisDefaultParameterHandler;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.baomidou.mybatisplus.extension.handlers.SqlParserHandler;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageHelper;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PaginationInterceptor
extends SqlParserHandler
implements Interceptor {
    private ISqlParser sqlParser;
    private boolean overflow = false;
    private String dialectType;
    private String dialectClazz;
    private boolean localPage = false;

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        this.sqlParser(metaObject);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (!SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        Object paramObj = boundSql.getParameterObject();
        IPage page = null;
        if (paramObj instanceof IPage) {
            page = (IPage)paramObj;
        } else if (paramObj instanceof Map) {
            for (Object arg : ((Map)paramObj).values()) {
                if (!(arg instanceof IPage)) continue;
                page = (IPage)arg;
                break;
            }
        }
        if (null == page) {
            if (this.localPage) {
                page = PageHelper.getPage();
                if (null == page) {
                    return invocation.proceed();
                }
            } else {
                return invocation.proceed();
            }
        }
        String originalSql = boundSql.getSql();
        Connection connection = (Connection)invocation.getArgs()[0];
        DbType dbType = StringUtils.isNotEmpty((CharSequence)this.dialectType) ? DbType.getDbType((String)this.dialectType) : JdbcUtils.getDbType(connection.getMetaData().getURL());
        boolean orderBy = true;
        if (null != page.getTotal() && page.getTotal().equals(0L)) {
            SqlInfo sqlInfo = SqlUtils.getOptimizeCountSql((boolean)page.optimizeCountSql(), (ISqlParser)this.sqlParser, (String)originalSql);
            orderBy = sqlInfo.isOrderBy();
            this.queryTotal(this.overflow, sqlInfo.getSql(), mappedStatement, boundSql, page, connection);
            if (page.getTotal() <= 0L) {
                return invocation.proceed();
            }
        }
        String buildSql = PaginationInterceptor.concatOrderBy(originalSql, page, orderBy);
        originalSql = DialectFactory.buildPaginationSql(page, buildSql, dbType, this.dialectClazz);
        metaObject.setValue("delegate.boundSql.sql", (Object)originalSql);
        metaObject.setValue("delegate.rowBounds.offset", (Object)0);
        metaObject.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
        return invocation.proceed();
    }

    public static String concatOrderBy(String originalSql, IPage page, boolean orderBy) {
        if (orderBy && (CollectionUtils.isNotEmpty((Collection)page.ascs()) || CollectionUtils.isNotEmpty((Collection)page.descs()))) {
            StringBuilder buildSql = new StringBuilder(originalSql);
            String ascStr = PaginationInterceptor.concatOrderBuilder(page.ascs(), " ASC");
            String descStr = PaginationInterceptor.concatOrderBuilder(page.descs(), " DESC");
            if (StringUtils.isNotEmpty((CharSequence)ascStr) && StringUtils.isNotEmpty((CharSequence)descStr)) {
                ascStr = ascStr + ", ";
            }
            if (StringUtils.isNotEmpty((CharSequence)ascStr) || StringUtils.isNotEmpty((CharSequence)descStr)) {
                buildSql.append(" ORDER BY ").append(ascStr).append(descStr);
            }
            return buildSql.toString();
        }
        return originalSql;
    }

    private static String concatOrderBuilder(List<String> columns, String orderWord) {
        if (CollectionUtils.isNotEmpty(columns)) {
            StringBuilder builder = new StringBuilder(16);
            int i = 0;
            while (i < columns.size()) {
                String cs = columns.get(i);
                if (StringUtils.isNotEmpty((CharSequence)cs)) {
                    builder.append(cs).append(orderWord);
                }
                if (++i == columns.size() || !StringUtils.isNotEmpty((CharSequence)cs)) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
        return "";
    }

    protected void queryTotal(boolean overflowCurrent, String sql, MappedStatement mappedStatement, BoundSql boundSql, IPage page, Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            MybatisDefaultParameterHandler parameterHandler = new MybatisDefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), boundSql);
            parameterHandler.setParameters(statement);
            long total = 0L;
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    total = resultSet.getLong(1);
                }
            }
            page.setTotal(Long.valueOf(total));
            long pages = page.getPages();
            if (overflowCurrent && Long.valueOf(page.getCurrent()).compareTo(pages) > 0) {
                page.setCurrent(1L);
            }
        }
        catch (Exception e) {
            throw new MybatisPlusException("Error: Method queryTotal execution error.", (Throwable)e);
        }
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
        String dialectType = prop.getProperty("dialectType");
        String dialectClazz = prop.getProperty("dialectClazz");
        String localPage = prop.getProperty("localPage");
        if (StringUtils.isNotEmpty((CharSequence)dialectType)) {
            this.dialectType = dialectType;
        }
        if (StringUtils.isNotEmpty((CharSequence)dialectClazz)) {
            this.dialectClazz = dialectClazz;
        }
        if (StringUtils.isNotEmpty((CharSequence)localPage)) {
            this.localPage = Boolean.valueOf(localPage);
        }
    }

    public PaginationInterceptor setDialectType(String dialectType) {
        this.dialectType = dialectType;
        return this;
    }

    public PaginationInterceptor setDialectClazz(String dialectClazz) {
        this.dialectClazz = dialectClazz;
        return this;
    }

    public PaginationInterceptor setOverflow(boolean overflow) {
        this.overflow = overflow;
        return this;
    }

    public PaginationInterceptor setSqlParser(ISqlParser sqlParser) {
        this.sqlParser = sqlParser;
        return this;
    }

    public PaginationInterceptor setLocalPage(boolean localPage) {
        this.localPage = localPage;
        return this;
    }
}

