/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.sharding;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.sql.DataSource;
import mybatis.mate.config.ShardingGroupProperty;
import mybatis.mate.sharding.O00000o0;
import mybatis.mate.sharding.ShardingDatasource;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.CollectionUtils;

public class ShardingHealthIndicator
extends AbstractHealthIndicator {
    private ShardingDatasource shardingDatasource;

    public ShardingHealthIndicator(ShardingDatasource shardingDatasource) {
        this.shardingDatasource = shardingDatasource;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Map<String, DataSource> map = this.shardingDatasource.getDataSources();
        Map<String, ShardingGroupProperty> map2 = O00000o0.O0000oo();
        AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        map2.forEach((string, shardingGroupProperty) -> {
            ShardingGroupProperty shardingGroupProperty2 = this.checkDbGroupProperty((ShardingGroupProperty)shardingGroupProperty, string2 -> (DataSource)map.get(string + string2));
            O00000o0.O000000o(string, shardingGroupProperty2);
            if (atomicBoolean.get() && shardingGroupProperty2.isHealth()) {
                atomicBoolean.set(false);
            }
            builder.withDetail(string, (Object)shardingGroupProperty2.isHealth());
        });
        builder.status(atomicBoolean.get() ? Status.DOWN : Status.UP);
    }

    protected ShardingGroupProperty checkDbGroupProperty(ShardingGroupProperty shardingGroupProperty, Function<String, DataSource> function) {
        List<String> list;
        ShardingGroupProperty shardingGroupProperty2 = new ShardingGroupProperty();
        List<String> list2 = shardingGroupProperty.getMasterKeys();
        if (!CollectionUtils.isEmpty(list2)) {
            list = new ArrayList<String>();
            for (String object : list2) {
                DataSource dataSource = function.apply(object);
                if (null == dataSource || !this.queryAvailable(dataSource)) continue;
                list.add(object);
            }
            if (!CollectionUtils.isEmpty(list)) {
                shardingGroupProperty2.setMasterKeys(list);
            }
        }
        if (!CollectionUtils.isEmpty(list = shardingGroupProperty.getSlaveKeys())) {
            ArrayList arrayList = new ArrayList();
            for (String string : list) {
                DataSource dataSource = function.apply(string);
                if (null == dataSource || !this.queryAvailable(dataSource)) continue;
                arrayList.add(string);
            }
            if (!CollectionUtils.isEmpty((Collection)arrayList)) {
                shardingGroupProperty2.setSlaveKeys(arrayList);
            }
        }
        return shardingGroupProperty2;
    }

    protected boolean queryAvailable(DataSource dataSource) {
        try {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            jdbcTemplate.setQueryTimeout(10);
            List list = new JdbcTemplate(dataSource).query("SELECT 1", (resultSet, n) -> {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                if (n2 != 1) {
                    throw new IncorrectResultSetColumnCountException(1, n2);
                }
                return (Integer)JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)1, Integer.class);
            });
            return (Integer)DataAccessUtils.requiredSingleResult((Collection)list) == 1;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

