/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.sharding;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import mybatis.mate.sharding.O00000o0;
import org.mybatis.spring.transaction.SpringManagedTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class O00000o
extends SpringManagedTransaction {
    private static final Logger log = LoggerFactory.getLogger(O00000o.class);
    private final DataSource dataSource;
    private Connection connection;
    private boolean isConnectionTransactional;
    private boolean autoCommit;
    private String currentDbKey;
    private Map<String, Connection> CONNECTION_MAP;

    public O00000o(DataSource dataSource) {
        super(dataSource);
        this.dataSource = dataSource;
        this.CONNECTION_MAP = new ConcurrentHashMap<String, Connection>();
        this.currentDbKey = this.getCurrentDbKey();
    }

    private String getCurrentDbKey() {
        return O00000o0.getDatabaseKeyOrElsePrimaryKey();
    }

    public Connection getConnection() throws SQLException {
        String string = this.getCurrentDbKey();
        if (Objects.equals(this.currentDbKey, string)) {
            if (null == this.connection) {
                this.openCurrentConnection();
            }
            return this.connection;
        }
        Connection connection = this.CONNECTION_MAP.get(string);
        if (null == connection || connection.isClosed()) {
            try {
                connection = this.dataSource.getConnection();
                this.CONNECTION_MAP.put(string, connection);
            }
            catch (SQLException sQLException) {
                throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", sQLException);
            }
        }
        return connection;
    }

    private void openCurrentConnection() throws SQLException {
        this.connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        this.autoCommit = this.connection.getAutoCommit();
        log.debug("this.autoCommit : {}", (Object)this.autoCommit);
        this.isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)this.connection, (DataSource)this.dataSource);
        log.debug(" this.isConnectionTransactional = {}", (Object)this.isConnectionTransactional);
    }

    public void commit() throws SQLException {
        super.commit();
    }

    public void rollback() throws SQLException {
        if (this.connection != null && this.isConnectionTransactional && !this.autoCommit) {
            log.debug("Rolling back JDBC Connection [{}]", (Object)this.connection);
            this.connection.rollback();
            for (Connection connection : this.CONNECTION_MAP.values()) {
                connection.rollback();
            }
        }
    }

    public void close() throws SQLException {
        DataSourceUtils.releaseConnection((Connection)this.connection, (DataSource)this.dataSource);
        for (Connection connection : this.CONNECTION_MAP.values()) {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }

    public Integer getTimeout() throws SQLException {
        return null;
    }
}

