/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.config;

import java.util.List;
import org.apache.ibatis.mapping.SqlCommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingGroupProperty {
    private static final Logger log = LoggerFactory.getLogger(ShardingGroupProperty.class);
    private List<String> masterKeys;
    private List<String> slaveKeys;

    public List<String> getDatasourceKeys(SqlCommandType sqlCommandType, String string) {
        if (null != this.slaveKeys && sqlCommandType == SqlCommandType.SELECT) {
            return this.slaveKeys;
        }
        if (null == this.masterKeys) {
            log.error("database group: [ {} ] master not available", (Object)string);
            return this.slaveKeys;
        }
        return this.masterKeys;
    }

    public boolean isHealth() {
        return null != this.masterKeys;
    }

    public List<String> getMasterKeys() {
        return this.masterKeys;
    }

    public List<String> getSlaveKeys() {
        return this.slaveKeys;
    }

    public void setMasterKeys(List<String> list) {
        this.masterKeys = list;
    }

    public void setSlaveKeys(List<String> list) {
        this.slaveKeys = list;
    }
}

