/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.cookie;

import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.cookie.CookieHandler;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DefaultCookieHandler
implements CookieHandler {
    private static final Logger log = Logger.getLogger(DefaultCookieHandler.class);

    public void invalidateCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("invalidateCookie " + cookieName + " for path " + path));
        }
        this.setCookie(request, response, cookieName, null, 0, path);
    }

    public Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies;
        boolean dbg = log.isDebugEnabled();
        if (dbg) {
            log.debug((Object)("Looking for a cookie named : '" + name + "'"));
        }
        if ((cookies = request.getCookies()) == null || name == null || name.length() == 0) {
            if (dbg && cookies == null) {
                log.debug((Object)"The Cookies array in the HTTP request is null");
            }
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            return cookies[i];
        }
        if (dbg) {
            log.debug((Object)("No cookie was found with name :" + name));
        }
        return null;
    }

    public Cookie setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge, String path) {
        boolean isInSecureCookie = SecurityConfigFactory.getInstance().isInsecureCookie();
        if (log.isDebugEnabled()) {
            log.debug((Object)("setCookie " + name + ":" + value + " path : " + path + " maxAge : " + maxAge + (isInSecureCookie ? " insecure" : " secure")));
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        if (!isInSecureCookie) {
            cookie.setSecure(request.isSecure());
        }
        response.addCookie(cookie);
        return cookie;
    }

    public String getCookieValue(HttpServletRequest request, String name) {
        Cookie cookie = this.getCookie(request, name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }
}

