/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.basic;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.wysiwyg.ListContext;
import com.atlassian.renderer.wysiwyg.Styles;
import com.atlassian.renderer.wysiwyg.WysiwygConverter;
import com.atlassian.renderer.wysiwyg.WysiwygNodeConverter;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InlineHtmlMacro
extends BaseMacro
implements WysiwygNodeConverter {
    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        if (renderContext.isRenderingForWysiwyg()) {
            StringBuffer sb = new StringBuffer();
            sb.append("<div class=\"wikisrc\">\n{html}</div><div wysiwyg=\"macro:html\">").append(body).append("</div><div class=\"wikisrc\">{html}</div>");
            return sb.toString();
        }
        return body;
    }

    public String convertXHtmlToWikiMarkup(Node previousSibling, Node node, WysiwygConverter helper, Styles styles, ListContext listContext, boolean inTable, boolean inListItem, boolean ignoreText) {
        return this.writeNodeListHTML(node.getChildNodes());
    }

    private String writeNodeListHTML(NodeList childNodes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            sb.append(this.writeNodeHTML(childNodes.item(i)));
        }
        return sb.toString();
    }

    private String writeNodeHTML(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        StringBuffer sb = new StringBuffer();
        return sb.append("<").append(node.getNodeName()).append(this.writeNodeAttributes(node)).append(">").append(this.writeNodeListHTML(node.getChildNodes())).append("</").append(node.getNodeName()).append(">").toString();
    }

    private String writeNodeAttributes(Node node) {
        StringBuffer sb = new StringBuffer("");
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                if (TextUtils.stringSet((String)attr.getNodeValue())) {
                    sb.append(" ").append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
                    continue;
                }
                sb.append(" ").append(attr.getNodeName());
            }
        }
        return sb.toString();
    }

    public boolean suppressSurroundingTagDuringWysiwygRendering() {
        return true;
    }
}

