/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RenderedContentStore;
import com.atlassian.renderer.util.RenderedContentToken;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.Renderable;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.components.AbstractRegexRendererComponent;
import java.util.regex.Matcher;

public class TokenRendererComponent
extends AbstractRegexRendererComponent {
    private static final RenderedContentToken BLOCK_TOKEN = RenderedContentStore.BLOCK_TOKEN;
    private static final RenderedContentToken INLINE_TOKEN = RenderedContentStore.INLINE_TOKEN;
    private final SubRenderer subRenderer;

    public TokenRendererComponent(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.resolveTokens() && renderMode.tokenizes();
    }

    public String render(String wiki, RenderContext context) {
        while (BLOCK_TOKEN.matches(wiki) || INLINE_TOKEN.matches(wiki)) {
            wiki = this.regexRender(wiki, context, BLOCK_TOKEN.getPattern());
            wiki = this.regexRender(wiki, context, INLINE_TOKEN.getPattern());
        }
        return wiki;
    }

    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        Object obj = context.getRenderedContentStore().get(matcher.group(0));
        if (obj instanceof Renderable) {
            Renderable renderable = (Renderable)obj;
            renderable.render(this.subRenderer, context, buffer);
        } else if (obj instanceof String) {
            buffer.append((String)obj);
        } else {
            throw new RuntimeException("Found object " + obj + " in token store?");
        }
    }
}

