/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.embedded.EmbeddedResourceParser;
import com.atlassian.renderer.embedded.EmbeddedResourceRenderer;
import com.atlassian.renderer.v2.components.AbstractRegexRendererComponent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractEmbeddedRendererComponent
extends AbstractRegexRendererComponent {
    static final Pattern EMBEDDED_PATTERN = Pattern.compile(AbstractEmbeddedRendererComponent.buildPhraseRegExp("\\!", "\\!"));

    public String render(String wiki, RenderContext context) {
        if (wiki.indexOf("!") == -1) {
            return wiki;
        }
        return this.regexRender(wiki, context, EMBEDDED_PATTERN);
    }

    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        String originalString = matcher.group(2);
        if (originalString.length() < 5 || originalString.charAt(0) == ')') {
            buffer.append("!").append(originalString).append("!");
            return;
        }
        EmbeddedResourceParser parser = new EmbeddedResourceParser(originalString);
        EmbeddedResource resource = this.findResource(context, parser, originalString);
        if (resource != null) {
            EmbeddedResourceRenderer renderer = context.getEmbeddedResourceRenderer();
            buffer.append(renderer.renderResource(resource, context));
        } else {
            buffer.append("!").append(originalString).append("!");
        }
    }

    protected abstract EmbeddedResource findResource(RenderContext var1, EmbeddedResourceParser var2, String var3);

    protected static String buildPhraseRegExp(String phrase_start_sign, String phrase_end_sign) {
        String valid_start = "(?<![\\p{L}\\p{Nd}\\\\])";
        String valid_end = "(?![\\p{L}\\p{Nd}])";
        String phrase_content = "[^\\s" + phrase_start_sign + "]((?!" + phrase_end_sign + ")[\\p{L}\\p{Nd}\\p{Z}\\p{S}\\p{M}\\p{P}]*?[^\\s" + phrase_end_sign + "])?";
        return "(^|" + valid_start + ")" + phrase_start_sign + "(" + phrase_content + ")(?<!\\\\)" + phrase_end_sign + "(" + valid_end + "|$)";
    }
}

