/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.util;

import com.atlassian.core.util.ClassLoaderUtils;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Properties;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.log4j.Category;

public class RendererProperties {
    public static String EMOTICONS_PATH = "icons/emoticons/";
    public static String ICONS_PATH = "icons/";
    public static String URL_LINK_TITLE = "renderer.external.link.title";
    public static String SITE_RELATIVE_LINK_TITLE = "renderer.site.relative.link.title";
    public static String RELATIVE_LINK_TITLE = "renderer.relative.link.title";
    public static String SEND_MAIL_TO = "renderer.send.mail.to";
    public static String TITLE_WITH_ANCHOR = "renderer.title.with.anchor";
    public static String ATTACHED_TO = "renderer.attached.to";
    public static String NEWS_ITEMS_FOR = "renderer.news.items.for";
    public static String NEWS_ITEMS_FOR_SPACEKEY = "renderer.news.items.for.spacekey";
    public static String CREATE_PAGE = "renderer.create.page";
    public static String CREATE_PAGE_IN_SPACE = "renderer.create.page.in.space";
    public static String EXTERNAL_SHORTCUT_LINK = "renderer.external.shortcut.link";
    public static String VIEW_SPACE = "renderer.view.space";
    public static String VIEW_PROFILE = "renderer.view.profile";
    private static final String propertiesFileName = "atlassian-renderer.properties";
    private static final Category log = Category.getInstance((Class)RendererProperties.class);

    static {
        Properties props = new Properties();
        InputStream propsStream = null;
        try {
            propsStream = ClassLoaderUtils.getResourceAsStream((String)propertiesFileName, (Class)RendererProperties.class);
            props.load(propsStream);
        }
        catch (Throwable t) {
            log.info((Object)"The atlassian-renderer was unable to find the atlassian-renderer.properties on the classpath, using default property values.");
        }
        Field[] fields = RendererProperties.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            String value = props.getProperty(name);
            if (value == null) continue;
            value = value.trim();
            Object oVal = ConvertUtils.convert((String)value, fields[i].getType());
            try {
                fields[i].set(null, oVal);
                continue;
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("The properties object of atlassian-renderer was unable to set the field: " + fields[i].getName()));
            }
        }
    }
}

