/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.util.RenderedContentToken;
import com.atlassian.renderer.v2.Renderable;
import com.atlassian.renderer.v2.Replacer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;

public class RenderedContentStore {
    private static Category log = Category.getInstance((Class)RenderedContentStore.class);
    public static final RenderedContentToken BLOCK_TOKEN = new RenderedContentToken("block");
    public static final RenderedContentToken INLINE_TOKEN = new RenderedContentToken("inline");
    public static final String MAP_KEY = "RenderedContentStore";
    private final Store store = new Store();

    public static RenderedContentStore getFromRenderContext(RenderContext renderContext) {
        return renderContext.getRenderedContentStore();
    }

    public String addBlock(Object content) {
        return this.store.add(content, BLOCK_TOKEN);
    }

    public String addInline(Object content) {
        return this.store.add(content, INLINE_TOKEN);
    }

    public Object get(String token) {
        try {
            if (token == null || token.length() < 3) {
                log.warn((Object)"Could not find stored token: the token was null or too short. A filter or macro may be broken.");
                return null;
            }
            return this.store.get(RenderedContentToken.getIndex(token));
        }
        catch (Exception e) {
            log.warn((Object)("Could not find stored token. A filter or macro may be broken. Exception: " + e.getMessage()));
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenderedContentStore)) {
            return false;
        }
        RenderedContentStore renderedContentStore = (RenderedContentStore)o;
        return !(this.store != null ? !this.store.equals(renderedContentStore.store) : renderedContentStore.store != null);
    }

    public int hashCode() {
        return this.store != null ? this.store.hashCode() : 0;
    }

    public static String stripTokens(String text) {
        text = new Replacer(BLOCK_TOKEN.getPattern(), "", new String[0]).replaceAll(text);
        return new Replacer(INLINE_TOKEN.getPattern(), "", new String[0]).replaceAll(text);
    }

    private final class Store {
        private final List list = new ArrayList();

        private Store() {
        }

        String add(Object content, RenderedContentToken delimiter) {
            if (!(content instanceof String) && !(content instanceof Renderable)) {
                throw new RuntimeException("You can only store String and Renderable objects.");
            }
            this.list.add(content);
            return delimiter.token(this.list.size() - 1);
        }

        public Object get(int index) {
            return this.list.get(index);
        }
    }
}

