/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand.parameter;

import com.atlassian.plugins.rest.common.expand.Expandable;
import com.atlassian.plugins.rest.common.expand.parameter.ChainingExpandParameter;
import com.atlassian.plugins.rest.common.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.common.expand.parameter.IndexParser;
import com.atlassian.plugins.rest.common.expand.parameter.Indexes;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultExpandParameter
implements ExpandParameter {
    private static final String DOT = ".";
    private static final String COMMA = ",";
    private static final String WILDCARD = "*";
    private static final ExpandParameter EMPTY_EXPAND_PARAMETER = new DefaultExpandParameter((String)null);
    private final Map<String, ExpandInformation> parameters;

    private DefaultExpandParameter(String expand) {
        this(StringUtils.isNotBlank((String)expand) ? Collections.singleton(expand) : Collections.emptyList());
    }

    public DefaultExpandParameter(Collection<String> expands) {
        this.parameters = DefaultExpandParameter.parse(expands != null ? expands : Collections.emptyList());
    }

    @Override
    public boolean shouldExpand(Expandable expandable) {
        return this.parameters.containsKey(WILDCARD) || this.parameters.containsKey(((Expandable)Preconditions.checkNotNull((Object)expandable)).value());
    }

    @Override
    public Indexes getIndexes(Expandable expandable) {
        ExpandInformation expandInformation = this.parameters.get(((Expandable)Preconditions.checkNotNull((Object)expandable)).value());
        return expandInformation != null ? expandInformation.getIndexes() : IndexParser.EMPTY;
    }

    @Override
    public ExpandParameter getExpandParameter(Expandable expandable) {
        ExpandInformation wildcardExpandInformation = this.parameters.get(WILDCARD);
        ExpandInformation valueExpandInformation = this.parameters.get(((Expandable)Preconditions.checkNotNull((Object)expandable)).value());
        return new ChainingExpandParameter(wildcardExpandInformation != null ? wildcardExpandInformation.getExpandParameter() : EMPTY_EXPAND_PARAMETER, valueExpandInformation != null ? valueExpandInformation.getExpandParameter() : EMPTY_EXPAND_PARAMETER);
    }

    @Override
    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    private static Map<String, ExpandInformation> parse(Collection<String> expands) {
        HashMap parameters = Maps.newHashMap();
        for (String expand : DefaultExpandParameter.preProcess(expands)) {
            if (!StringUtils.isNotEmpty((String)expand)) continue;
            ExpandKey key = ExpandKey.from(StringUtils.substringBefore((String)expand, (String)DOT));
            parameters.put(key.getName(), new ExpandInformation(key.getIndexes(), new DefaultExpandParameter(StringUtils.substringAfter((String)expand, (String)DOT))));
        }
        return parameters;
    }

    private static Collection<String> preProcess(Collection<String> expands) {
        HashSet<String> preProcessed = new HashSet<String>();
        for (String expand : expands) {
            preProcessed.addAll(Sets.newHashSet((Object[])expand.split(COMMA)));
        }
        return preProcessed;
    }

    private static class ExpandInformation {
        private final Indexes indexes;
        private final ExpandParameter expandParameter;

        public ExpandInformation(Indexes indexes, ExpandParameter expandParameter) {
            this.indexes = (Indexes)Preconditions.checkNotNull((Object)indexes);
            this.expandParameter = (ExpandParameter)Preconditions.checkNotNull((Object)expandParameter);
        }

        public Indexes getIndexes() {
            return this.indexes;
        }

        public ExpandParameter getExpandParameter() {
            return this.expandParameter;
        }
    }

    private static class ExpandKey {
        private static final Pattern KEY_PATTERN = Pattern.compile("(\\w+|\\*)(?:\\[([\\d:\\-\\|]+)\\])?");
        private final String name;
        private final Indexes indexes;

        ExpandKey(String name, Indexes indexes) {
            this.name = name;
            this.indexes = indexes;
        }

        public String getName() {
            return this.name;
        }

        public Indexes getIndexes() {
            return this.indexes;
        }

        private static ExpandKey from(String key) {
            Matcher keyMatcher = KEY_PATTERN.matcher(key);
            if (!keyMatcher.matches()) {
                throw new RuntimeException("key <" + key + "> doesn't match pattern");
            }
            String name = keyMatcher.group(1);
            String indexesString = keyMatcher.group(2);
            return new ExpandKey(name, IndexParser.parse(indexesString));
        }
    }
}

