/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.json.marshal.wrapped.JsonableBoolean;
import com.atlassian.json.marshal.wrapped.JsonableNumber;
import com.atlassian.json.marshal.wrapped.JsonableString;
import com.atlassian.plugin.webresource.ContextBatchBuilder;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.SuperBatchBuilder;
import com.atlassian.plugin.webresource.TransformDescriptorToKey;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceSet;
import com.atlassian.plugin.webresource.data.DefaultPluginDataResource;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.webresource.api.assembler.AssembledResources;
import com.atlassian.webresource.api.assembler.RequiredData;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.data.PluginDataResource;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultWebResourceAssembler
implements WebResourceAssembler {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebResourceAssembler.class);
    private final Set<String> webResourcesToInclude;
    private final Set<String> contextsToInclude;
    private final Map<String, Jsonable> dataToInclude;
    private final AssembledResources assembledResources;
    private final RequiredResources requiredResources;
    private final RequiredData requiredData;
    private final ResourceRequirer resourceRequirer;
    private InclusionState inclusion;

    public DefaultWebResourceAssembler(ResourceBatchingConfiguration batchingConfiguration, WebResourceIntegration webResourceIntegration, PluginResourceLocator pluginResourceLocator, WebResourceUrlProvider webResourceUrlProvider, StaticTransformers staticTransformers) {
        this(batchingConfiguration, webResourceIntegration, pluginResourceLocator, webResourceUrlProvider, staticTransformers, Sets.newLinkedHashSet(), Sets.newLinkedHashSet(), Maps.newLinkedHashMap(), new InclusionState(false, Sets.newHashSet(), Sets.newHashSet(), Sets.newHashSet()));
    }

    private DefaultWebResourceAssembler(ResourceBatchingConfiguration batchingConfiguration, WebResourceIntegration webResourceIntegration, PluginResourceLocator pluginResourceLocator, WebResourceUrlProvider webResourceUrlProvider, StaticTransformers staticTransformers, Set<String> webResourcesToInclude, Set<String> contextsToInclude, Map<String, Jsonable> dataToInclude, InclusionState inclusionState) {
        this.resourceRequirer = new ResourceRequirer(batchingConfiguration, webResourceIntegration, webResourceUrlProvider, pluginResourceLocator, new DefaultResourceDependencyResolver(webResourceIntegration, batchingConfiguration), staticTransformers);
        this.webResourcesToInclude = webResourcesToInclude;
        this.contextsToInclude = contextsToInclude;
        this.dataToInclude = dataToInclude;
        this.inclusion = inclusionState;
        this.assembledResources = new DefaultAssembledResources();
        this.requiredResources = new DefaultRequiredResources();
        this.requiredData = new DefaultRequiredData();
    }

    public AssembledResources assembled() {
        return this.assembledResources;
    }

    public RequiredResources resources() {
        return this.requiredResources;
    }

    public RequiredData data() {
        return this.requiredData;
    }

    public WebResourceAssembler copy() {
        return new DefaultWebResourceAssembler(this.resourceRequirer.batchingConfiguration, this.resourceRequirer.webResourceIntegration, this.resourceRequirer.pluginResourceLocator, this.resourceRequirer.webResourceUrlProvider, this.resourceRequirer.staticTransformers, Sets.newLinkedHashSet(this.webResourcesToInclude), Sets.newLinkedHashSet(this.contextsToInclude), Maps.newLinkedHashMap(this.dataToInclude), this.inclusion.copy());
    }

    private static class ResourceRequirer {
        private final ResourceBatchingConfiguration batchingConfiguration;
        private final WebResourceIntegration webResourceIntegration;
        private final WebResourceUrlProvider webResourceUrlProvider;
        private final PluginResourceLocator pluginResourceLocator;
        private final ResourceDependencyResolver dependencyResolver;
        private final StaticTransformers staticTransformers;

        private ResourceRequirer(ResourceBatchingConfiguration batchingConfiguration, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, PluginResourceLocator pluginResourceLocator, ResourceDependencyResolver dependencyResolver, StaticTransformers staticTransformers) {
            this.batchingConfiguration = batchingConfiguration;
            this.webResourceIntegration = webResourceIntegration;
            this.webResourceUrlProvider = webResourceUrlProvider;
            this.pluginResourceLocator = pluginResourceLocator;
            this.dependencyResolver = dependencyResolver;
            this.staticTransformers = staticTransformers;
        }

        private WebResourceSet includeResources(Set<String> requiredWebResources, Set<String> requiredContexts, Map<String, Jsonable> requiredData, WebResourceFilter filter, InclusionState inclusion) {
            Resources resourcesToInclude = new Resources();
            this.addSuperBatchResources(resourcesToInclude, filter, inclusion);
            this.addContextBatchDependencies(resourcesToInclude, filter, requiredWebResources, requiredContexts, inclusion);
            Iterable<String> dependencyModuleKeys = this.getAllModuleKeysDependencies(requiredWebResources);
            this.addModuleResources(resourcesToInclude, dependencyModuleKeys, inclusion.webresources, filter);
            for (Map.Entry<String, Jsonable> data : requiredData.entrySet()) {
                if (inclusion.dataKeys.contains(data.getKey())) continue;
                resourcesToInclude.data.add(new DefaultPluginDataResource(data.getKey(), data.getValue()));
            }
            Iterables.addAll((Collection)inclusion.contexts, requiredContexts);
            Iterables.addAll((Collection)inclusion.webresources, dependencyModuleKeys);
            Iterables.addAll((Collection)inclusion.dataKeys, requiredData.keySet());
            return new DefaultWebResourceSet(this.batchingConfiguration, this.webResourceUrlProvider, this.webResourceIntegration, resourcesToInclude.resources, resourcesToInclude.data);
        }

        private void addSuperBatchResources(Resources resourcesToInclude, WebResourceFilter filter, InclusionState inclusion) {
            if (inclusion.superbatch || !this.batchingConfiguration.isSuperBatchingEnabled()) {
                return;
            }
            inclusion.superbatch = true;
            Iterables.addAll((Collection)resourcesToInclude.resources, new SuperBatchBuilder(this.dependencyResolver, this.pluginResourceLocator, this.webResourceIntegration).build(filter));
            for (WebResourceModuleDescriptor wrmd : this.dependencyResolver.getSuperBatchDependencies()) {
                Iterables.addAll((Collection)resourcesToInclude.data, this.pluginResourceLocator.getPluginDataResources(wrmd.getCompleteKey()));
            }
        }

        private void addContextBatchDependencies(Resources resourcesToInclude, WebResourceFilter filter, Set<String> requiredWebResources, Set<String> requiredContexts, InclusionState inclusion) {
            ContextBatchBuilder builder = new ContextBatchBuilder(this.webResourceIntegration.getPluginAccessor(), this.staticTransformers, this.pluginResourceLocator, this.dependencyResolver, this.batchingConfiguration);
            Iterable<PluginResource> contextResources = builder.build(new ArrayList<String>(requiredContexts), inclusion.contexts, filter);
            boolean isAnyContextAlreadyIncluded = false;
            for (String moduleKey : builder.getAllIncludedResources()) {
                if (inclusion.webresources.contains(moduleKey)) {
                    isAnyContextAlreadyIncluded = true;
                    log.debug("The module '{}' has already been included in the Assembler. Inclusion contexts = {}, required contexts = {}", new Object[]{moduleKey, inclusion.contexts, requiredContexts});
                    continue;
                }
                Iterables.addAll((Collection)resourcesToInclude.data, this.pluginResourceLocator.getPluginDataResources(moduleKey));
            }
            if (isAnyContextAlreadyIncluded) {
                Iterables.addAll(requiredWebResources, builder.getAllIncludedResources());
            } else {
                Iterables.addAll((Collection)resourcesToInclude.resources, contextResources);
                Iterables.addAll((Collection)inclusion.webresources, builder.getAllIncludedResources());
            }
            Iterables.addAll(requiredWebResources, builder.getSkippedResources());
        }

        private Iterable<String> getAllModuleKeysDependencies(Iterable<String> moduleCompleteKeys) {
            LinkedHashSet dependencyModuleCompleteKeys = Sets.newLinkedHashSet();
            for (String moduleCompleteKey : moduleCompleteKeys) {
                Iterable<String> dependencies = this.toModuleKeys(this.dependencyResolver.getDependencies(moduleCompleteKey, this.batchingConfiguration.isSuperBatchingEnabled()));
                Iterables.addAll((Collection)dependencyModuleCompleteKeys, dependencies);
            }
            return dependencyModuleCompleteKeys;
        }

        private void addModuleResources(Resources resourcesToInclude, Iterable<String> dependencyModuleCompleteKeys, Set<String> excludeModuleKeys, WebResourceFilter filter) {
            for (String moduleKey : dependencyModuleCompleteKeys) {
                if (excludeModuleKeys.contains(moduleKey)) continue;
                List<PluginResource> moduleResources = this.pluginResourceLocator.getPluginResources(moduleKey);
                for (PluginResource moduleResource : moduleResources) {
                    if (!filter.matches(moduleResource.getResourceName())) continue;
                    resourcesToInclude.resources.add(moduleResource);
                }
                Iterables.addAll((Collection)resourcesToInclude.data, this.pluginResourceLocator.getPluginDataResources(moduleKey));
            }
        }

        private Iterable<String> toModuleKeys(Iterable<WebResourceModuleDescriptor> descriptors) {
            return Iterables.transform(descriptors, (Function)new TransformDescriptorToKey());
        }

        private static class Resources {
            private final Collection<PluginResource> resources = Lists.newLinkedList();
            private final Collection<PluginDataResource> data = Lists.newLinkedList();

            private Resources() {
            }
        }
    }

    private final class DefaultAssembledResources
    implements AssembledResources {
        private DefaultAssembledResources() {
        }

        public WebResourceSet drainIncludedResources() {
            InclusionState nextInclusion = DefaultWebResourceAssembler.this.inclusion.copy();
            WebResourceSet webResourceSet = DefaultWebResourceAssembler.this.resourceRequirer.includeResources(DefaultWebResourceAssembler.this.webResourcesToInclude, DefaultWebResourceAssembler.this.contextsToInclude, DefaultWebResourceAssembler.this.dataToInclude, DefaultWebResourceFilter.INSTANCE, nextInclusion);
            DefaultWebResourceAssembler.this.webResourcesToInclude.clear();
            DefaultWebResourceAssembler.this.contextsToInclude.clear();
            DefaultWebResourceAssembler.this.dataToInclude.clear();
            DefaultWebResourceAssembler.this.inclusion = nextInclusion;
            return webResourceSet;
        }

        public WebResourceSet peek() {
            InclusionState fakeInclusion = DefaultWebResourceAssembler.this.inclusion.copy();
            return DefaultWebResourceAssembler.this.resourceRequirer.includeResources(DefaultWebResourceAssembler.this.webResourcesToInclude, DefaultWebResourceAssembler.this.contextsToInclude, DefaultWebResourceAssembler.this.dataToInclude, DefaultWebResourceFilter.INSTANCE, fakeInclusion);
        }
    }

    private final class DefaultRequiredData
    implements RequiredData {
        private DefaultRequiredData() {
        }

        public RequiredData requireData(String key, Jsonable content) {
            DefaultWebResourceAssembler.this.dataToInclude.put(key, content);
            return this;
        }

        public RequiredData requireData(String key, Number content) {
            DefaultWebResourceAssembler.this.dataToInclude.put(key, new JsonableNumber(content));
            return this;
        }

        public RequiredData requireData(String key, String content) {
            DefaultWebResourceAssembler.this.dataToInclude.put(key, new JsonableString(content));
            return this;
        }

        public RequiredData requireData(String key, Boolean content) {
            DefaultWebResourceAssembler.this.dataToInclude.put(key, new JsonableBoolean(content));
            return this;
        }
    }

    private final class DefaultRequiredResources
    implements RequiredResources {
        private DefaultRequiredResources() {
        }

        public RequiredResources requireWebResource(String moduleCompleteKey) {
            DefaultWebResourceAssembler.this.webResourcesToInclude.add(moduleCompleteKey);
            return this;
        }

        public RequiredResources requireContext(String context) {
            DefaultWebResourceAssembler.this.contextsToInclude.add(context);
            return this;
        }

        public RequiredResources exclude(Set<String> webResources, Set<String> contexts) {
            InclusionState nextInclusion = DefaultWebResourceAssembler.this.inclusion.copy();
            HashSet excludeWebResources = null == webResources ? Collections.emptySet() : Sets.newHashSet(webResources);
            HashSet excludeContexts = null == contexts ? Collections.emptySet() : Sets.newHashSet(contexts);
            DefaultWebResourceAssembler.this.resourceRequirer.includeResources(excludeWebResources, excludeContexts, Collections.emptyMap(), DefaultWebResourceFilter.INSTANCE, nextInclusion);
            DefaultWebResourceAssembler.this.inclusion = nextInclusion;
            return this;
        }
    }

    private static class InclusionState {
        private boolean superbatch;
        private Set<String> webresources;
        private Set<String> contexts;
        private Set<String> dataKeys;

        public InclusionState(boolean superbatch, Set<String> webresources, Set<String> contexts, Set<String> dataKeys) {
            this.superbatch = superbatch;
            this.webresources = webresources;
            this.contexts = contexts;
            this.dataKeys = dataKeys;
        }

        public InclusionState copy() {
            return new InclusionState(this.superbatch, Sets.newHashSet(this.webresources), Sets.newHashSet(this.contexts), Sets.newHashSet(this.dataKeys));
        }
    }
}

