/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.AbstractPluginResource;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.ResourceKey;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.url.UrlParameters;
import java.util.HashSet;
import java.util.Map;

public class SuperBatchPluginResource
extends AbstractPluginResource {
    static final String URL_PREFIX = "/download/superbatch/";
    static final String DEFAULT_RESOURCE_NAME_PREFIX = "batch";
    private final ResourceKey resource;

    public static SuperBatchPluginResource createBatchFor(PluginResource pluginResource) {
        return new SuperBatchPluginResource(pluginResource.getType(), pluginResource.getUrlParameters(), pluginResource.getParams());
    }

    public SuperBatchPluginResource(String type, UrlParameters urlParams, Map<String, String> params) {
        this(ResourceKey.Builder.batch(type), urlParams, params);
    }

    protected SuperBatchPluginResource(ResourceKey resource, UrlParameters urlParams, Map<String, String> params) {
        super(urlParams, params, new HashSet<BatchedWebResourceDescriptor>());
        this.resource = resource;
    }

    @Override
    public String getUrl() {
        StringBuilder buf = new StringBuilder(URL_PREFIX.length() + 20);
        buf.append(URL_PREFIX).append(this.getType()).append("/").append(this.getResourceName());
        ResourceUtils.addParamsToUrl(buf, this.getParams(), this.getBatchableParams());
        return buf.toString();
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        return integration.getSuperBatchVersion();
    }

    @Override
    public String getType() {
        return this.resource.suffix();
    }

    @Override
    public boolean isCacheSupported() {
        return true;
    }

    @Override
    public String getResourceName() {
        return this.resource.name();
    }

    @Override
    public String getModuleCompleteKey() {
        return "superbatch";
    }

    void addBatchedWebResourceDescriptor(BatchedWebResourceDescriptor descriptor) {
        this.batchedWebResourceDescriptors.add(descriptor);
    }

    public String toString() {
        return "[Superbatch type=" + this.getType() + ", params=" + this.getParams() + "]";
    }
}

