/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.DownloadableResourceBuilder;
import com.atlassian.plugin.webresource.DownloadableResourceFinder;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.UrlParseException;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import java.util.Map;

public class SuperBatchSubResourceBuilder
implements DownloadableResourceBuilder {
    private final ResourceDependencyResolver dependencyResolver;
    private final DownloadableResourceFinder resourceFinder;

    public SuperBatchSubResourceBuilder(ResourceDependencyResolver dependencyResolver, DownloadableResourceFinder resourceFinder) {
        this.dependencyResolver = dependencyResolver;
        this.resourceFinder = resourceFinder;
    }

    @Override
    public boolean matches(String path) {
        return path.indexOf("/download/superbatch/") > -1;
    }

    @Override
    public DownloadableResource parse(String path, Map<String, String> params) throws UrlParseException {
        String resourceName = this.getResourceName(path);
        for (WebResourceModuleDescriptor moduleDescriptor : this.dependencyResolver.getSuperBatchDependencies()) {
            DownloadableResource resource = this.resourceFinder.find(moduleDescriptor.getCompleteKey(), resourceName, params);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private String getResourceName(String path) {
        int startIndex = path.indexOf("/download/superbatch/") + "/download/superbatch/".length();
        return path.substring(startIndex);
    }
}

