/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.fugue.Option;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.cache.filecache.FileCache;
import com.atlassian.plugin.cache.filecache.impl.FileCacheImpl;
import com.atlassian.plugin.cache.filecache.impl.PassThroughFileCache;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.util.PluginUtils;
import com.atlassian.plugin.webresource.AbstractBatchResourceBuilder;
import com.atlassian.plugin.webresource.AbstractPluginResource;
import com.atlassian.plugin.webresource.BatchPluginResource;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.ContextBatchDownloadableResourceBuilder;
import com.atlassian.plugin.webresource.ContextBatchSubResourceBuilder;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.DownloadableResourceBuilder;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.ResourceKey;
import com.atlassian.plugin.webresource.SingleBatchDownloadableResourceBuilder;
import com.atlassian.plugin.webresource.SingleDownloadableResourceBuilder;
import com.atlassian.plugin.webresource.SinglePluginResource;
import com.atlassian.plugin.webresource.SuperBatchDownloadableResourceBuilder;
import com.atlassian.plugin.webresource.SuperBatchSubResourceBuilder;
import com.atlassian.plugin.webresource.UrlParseException;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.cache.FileCacheKey;
import com.atlassian.plugin.webresource.data.DefaultPluginDataResource;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilder;
import com.atlassian.plugin.webresource.url.NamedHash;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.webresource.api.data.PluginDataResource;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginResourceLocatorImpl
implements PluginResourceLocator {
    private static final Logger log = LoggerFactory.getLogger(PluginResourceLocatorImpl.class);
    private final PluginAccessor pluginAccessor;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final List<DownloadableResourceBuilder> builders;
    private final FileCache<FileCacheKey> fileCache;
    private static final AtomicLong FILENAME_COUNTER = new AtomicLong(0L);
    static final String RESOURCE_SOURCE_PARAM = "source";
    static final String RESOURCE_BATCH_PARAM = "batch";
    static final int DEFAULT_CACHE_SIZE = 1000;

    public PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, WebResourceUrlProvider webResourceUrlProvider, PluginEventManager pluginEventManager) {
        this(webResourceIntegration, servletContextFactory, webResourceUrlProvider, new DefaultResourceBatchingConfiguration(), pluginEventManager);
    }

    public PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration, PluginEventManager pluginEventManager) {
        this(webResourceIntegration, servletContextFactory, webResourceUrlProvider, new DefaultResourceDependencyResolver(webResourceIntegration, batchingConfiguration), batchingConfiguration, pluginEventManager);
    }

    private PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, WebResourceUrlProvider webResourceUrlProvider, ResourceDependencyResolver dependencyResolver, ResourceBatchingConfiguration batchingConfiguration, PluginEventManager pluginEventManager) {
        this.pluginAccessor = webResourceIntegration.getPluginAccessor();
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.batchingConfiguration = batchingConfiguration;
        SingleDownloadableResourceBuilder singlePluginBuilder = new SingleDownloadableResourceBuilder(this.pluginAccessor, servletContextFactory, webResourceIntegration);
        FileCache<FileCacheKey> cache = PluginResourceLocatorImpl.makePhysicalCache(webResourceIntegration);
        if (cache == null) {
            cache = PassThroughFileCache.instance();
        }
        this.fileCache = cache;
        this.builders = Collections.unmodifiableList(Arrays.asList(new SuperBatchDownloadableResourceBuilder(dependencyResolver, this.pluginAccessor, webResourceUrlProvider, singlePluginBuilder, cache, batchingConfiguration), new SuperBatchSubResourceBuilder(dependencyResolver, singlePluginBuilder), new ContextBatchDownloadableResourceBuilder(dependencyResolver, this.pluginAccessor, webResourceUrlProvider, singlePluginBuilder, cache, batchingConfiguration), new ContextBatchSubResourceBuilder(dependencyResolver, singlePluginBuilder), new SingleBatchDownloadableResourceBuilder(this.pluginAccessor, webResourceUrlProvider, singlePluginBuilder, cache, batchingConfiguration), singlePluginBuilder));
        pluginEventManager.register((Object)this);
    }

    private static FileCache<FileCacheKey> makePhysicalCache(WebResourceIntegration webResourceIntegration) {
        boolean cacheDisabled;
        boolean bl = cacheDisabled = Boolean.getBoolean(PluginUtils.WEBRESOURCE_DISABLE_FILE_CACHE) || Boolean.getBoolean("atlassian.dev.mode");
        if (cacheDisabled) {
            return null;
        }
        FileCacheImpl cache = null;
        try {
            int cachesize = Integer.getInteger(PluginUtils.WEBRESOURCE_FILE_CACHE_SIZE, 1000);
            File tmpDir = webResourceIntegration.getTemporaryDirectory();
            if (tmpDir != null) {
                cache = new FileCacheImpl(tmpDir, cachesize, FILENAME_COUNTER);
            }
        }
        catch (IOException e) {
            log.error("Could not create file cache object, will startup with filecaching disabled, please investigate the cause and correct it.", (Throwable)e);
        }
        return cache;
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.fileCache.clear();
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.fileCache.clear();
    }

    @Override
    public boolean matches(String url) {
        for (DownloadableResourceBuilder builder : this.builders) {
            if (!builder.matches(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DownloadableResource getDownloadableResource(String url, Map<String, String> queryParams) {
        try {
            for (DownloadableResourceBuilder builder : this.builders) {
                if (!builder.matches(url)) continue;
                return builder.parse(url, queryParams);
            }
        }
        catch (UrlParseException e) {
            log.error("Unable to parse URL: " + url, (Throwable)e);
        }
        return null;
    }

    @Override
    public Iterable<PluginDataResource> getPluginDataResources(final String moduleCompleteKey) {
        Option<WebResourceModuleDescriptor> option = this.getDescriptor(moduleCompleteKey);
        if (option.isEmpty()) {
            return Collections.emptyList();
        }
        return Iterables.transform(((WebResourceModuleDescriptor)((Object)option.get())).getDataProviders().entrySet(), (Function)new Function<Map.Entry<String, WebResourceDataProvider>, PluginDataResource>(){

            public PluginDataResource apply(@Nullable Map.Entry<String, WebResourceDataProvider> input) {
                return new DefaultPluginDataResource(moduleCompleteKey + "." + input.getKey(), (Jsonable)input.getValue().get());
            }
        });
    }

    @Override
    public List<PluginResource> getPluginResources(String moduleCompleteKey) {
        Option<WebResourceModuleDescriptor> option = this.getDescriptor(moduleCompleteKey);
        if (option.isEmpty()) {
            return Collections.emptyList();
        }
        WebResourceModuleDescriptor wrmd = (WebResourceModuleDescriptor)((Object)option.get());
        boolean singleMode = !this.batchingConfiguration.isPluginWebResourceBatchingEnabled();
        LinkedHashSet<AbstractPluginResource> resources = new LinkedHashSet<AbstractPluginResource>();
        DefaultUrlBuilder urlBuilder = new DefaultUrlBuilder();
        wrmd.addToUrl(this.pluginAccessor, urlBuilder);
        for (ResourceDescriptor resourceDescriptor : wrmd.getResourceDescriptors()) {
            if (singleMode || AbstractBatchResourceBuilder.skipBatch(resourceDescriptor)) {
                boolean cache = !"false".equalsIgnoreCase(resourceDescriptor.getParameter("cache"));
                resources.add(new SinglePluginResource(resourceDescriptor.getName(), wrmd.getCompleteKey(), cache, urlBuilder.allHashes(), resourceDescriptor.getParameters(), urlBuilder.toQueryString()));
                continue;
            }
            BatchPluginResource batchResource = this.createBatchResource(wrmd.getCompleteKey(), resourceDescriptor, urlBuilder.allHashes(), urlBuilder.toQueryString(), new BatchedWebResourceDescriptor(wrmd.getPlugin().getPluginInformation().getVersion(), wrmd.getCompleteKey()));
            resources.add(batchResource);
        }
        return ImmutableList.copyOf(resources);
    }

    private Option<WebResourceModuleDescriptor> getDescriptor(String moduleCompleteKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(moduleCompleteKey);
        if (moduleDescriptor == null || !(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            log.error("Error loading resource \"{}\". Resource is not a Web Resource Module", (Object)moduleCompleteKey);
            return Option.none();
        }
        return Option.some((Object)((Object)((WebResourceModuleDescriptor)moduleDescriptor)));
    }

    String[] splitLastPathPart(String resourcePath) {
        int indexOfSlash = resourcePath.lastIndexOf(47);
        if (resourcePath.endsWith("/")) {
            indexOfSlash = resourcePath.lastIndexOf(47, indexOfSlash - 1);
        }
        if (indexOfSlash < 0) {
            return null;
        }
        return new String[]{resourcePath.substring(0, indexOfSlash + 1), resourcePath.substring(indexOfSlash + 1)};
    }

    private BatchPluginResource createBatchResource(String moduleCompleteKey, ResourceDescriptor resourceDescriptor, List<NamedHash> hashes, Map<String, String> batchableParams, BatchedWebResourceDescriptor batchedWebResourceDescriptor) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (String param : BATCH_PARAMS) {
            String value = resourceDescriptor.getParameter(param);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            params.put(param, value);
        }
        final String name = resourceDescriptor.getName();
        LazyReference<String> type = new LazyReference<String>(){

            protected String create() {
                return name.substring(name.lastIndexOf(".") + 1);
            }
        };
        return new BatchPluginResource(ResourceKey.Builder.lazy(moduleCompleteKey, (Supplier<String>)type), hashes, params, batchableParams, batchedWebResourceDescriptor);
    }

    public String getResourceUrl(String moduleCompleteKey, String resourceName) {
        return this.webResourceUrlProvider.getResourceUrl(moduleCompleteKey, resourceName);
    }
}

