/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceDependencyResolver
implements ResourceDependencyResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceDependencyResolver.class);
    private final WebResourceIntegration webResourceIntegration;
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final Cache cached = new Cache();

    public DefaultResourceDependencyResolver(WebResourceIntegration webResourceIntegration, ResourceBatchingConfiguration batchingConfiguration) {
        this.webResourceIntegration = webResourceIntegration;
        this.batchingConfiguration = batchingConfiguration;
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getSuperBatchDependencies() {
        return this.cached.resourceMap().values();
    }

    private Iterable<String> getSuperBatchDependencyKeys() {
        return this.cached.resourceMap().keySet();
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getDependencies(String moduleKey, boolean excludeSuperBatchedResources) {
        LinkedHashMap<String, WebResourceModuleDescriptor> orderedResources = new LinkedHashMap<String, WebResourceModuleDescriptor>();
        List<String> superBatchResources = excludeSuperBatchedResources ? this.getSuperBatchDependencyKeys() : Collections.emptyList();
        this.resolveDependencies(moduleKey, orderedResources, superBatchResources, new Stack<String>(), null);
        return orderedResources.values();
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getDependenciesInContext(String context) {
        return this.getDependenciesInContext(context, new LinkedHashSet<String>());
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getDependenciesInContext(String context, boolean excludeSuperBatchedResources) {
        return this.getDependenciesInContext(context, excludeSuperBatchedResources, new LinkedHashSet<String>());
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getDependenciesInContext(String context, Set<String> skippedResources) {
        return this.getDependenciesInContext(context, true, skippedResources);
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getDependenciesInContext(String context, boolean excludeSuperBatchedResources, Set<String> skippedResources) {
        LinkedHashSet<WebResourceModuleDescriptor> contextResources = new LinkedHashSet<WebResourceModuleDescriptor>();
        Class<WebResourceModuleDescriptor> clazz = WebResourceModuleDescriptor.class;
        for (WebResourceModuleDescriptor descriptor : this.webResourceIntegration.getPluginAccessor().getEnabledModuleDescriptorsByClass(clazz)) {
            if (!descriptor.getContexts().contains(context)) continue;
            LinkedHashMap<String, WebResourceModuleDescriptor> dependencies = new LinkedHashMap<String, WebResourceModuleDescriptor>();
            List<String> superBatchResources = excludeSuperBatchedResources ? this.getSuperBatchDependencyKeys() : Collections.emptyList();
            this.resolveDependencies(descriptor.getCompleteKey(), dependencies, superBatchResources, new Stack<String>(), skippedResources);
            for (WebResourceModuleDescriptor dependency : dependencies.values()) {
                contextResources.add(dependency);
            }
        }
        return Collections.unmodifiableCollection(contextResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveDependencies(String moduleKey, Map<String, WebResourceModuleDescriptor> orderedResourceKeys, Iterable<String> superBatchResources, Stack<String> stack, Set<String> skippedResources) {
        if (Iterables.contains(superBatchResources, (Object)moduleKey)) {
            log.debug("Not requiring resource: {} because it is part of a super-batch", (Object)moduleKey);
            return;
        }
        if (stack.contains(moduleKey)) {
            log.warn("Cyclic plugin resource dependency has been detected with: {} \nStack trace: {}", (Object)moduleKey, stack);
            return;
        }
        ModuleDescriptor moduleDescriptor = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(moduleKey);
        if (!(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            if (this.webResourceIntegration.getPluginAccessor().getPluginModule(moduleKey) != null) {
                log.warn("Cannot include disabled web resource module: {}", (Object)moduleKey);
            } else {
                log.warn("Cannot find web resource module for: {}", (Object)moduleKey);
            }
            return;
        }
        WebResourceModuleDescriptor webResourceModuleDescriptor = (WebResourceModuleDescriptor)moduleDescriptor;
        if (!webResourceModuleDescriptor.canEncodeStateIntoUrl()) {
            if (null != skippedResources) {
                skippedResources.add(moduleKey);
                return;
            }
            if (!webResourceModuleDescriptor.shouldDisplayImmediate()) {
                log.debug("Cannot include web resource module {} as its condition fails", (Object)moduleDescriptor.getCompleteKey());
                return;
            }
        }
        List<String> dependencies = webResourceModuleDescriptor.getDependencies();
        log.debug("About to add resource [{}] and its dependencies: {}", (Object)moduleKey, dependencies);
        stack.push(moduleKey);
        try {
            for (String dependency : dependencies) {
                if (orderedResourceKeys.get(dependency) != null) continue;
                this.resolveDependencies(dependency, orderedResourceKeys, superBatchResources, stack, skippedResources);
            }
        }
        finally {
            stack.pop();
        }
        orderedResourceKeys.put(moduleKey, webResourceModuleDescriptor);
    }

    static final class SuperBatch {
        final String version;
        final Map<String, WebResourceModuleDescriptor> resources;

        SuperBatch(String version, Map<String, WebResourceModuleDescriptor> resources) {
            this.version = (String)Preconditions.checkNotNull((Object)version);
            this.resources = (Map)Preconditions.checkNotNull(resources);
        }
    }

    final class Cache {
        ResettableLazyReference<SuperBatch> lazy = new ResettableLazyReference<SuperBatch>(){

            protected SuperBatch create() throws Exception {
                String version = DefaultResourceDependencyResolver.this.webResourceIntegration.getSuperBatchVersion();
                return new SuperBatch(version, this.loadDescriptors(DefaultResourceDependencyResolver.this.batchingConfiguration.getSuperBatchModuleCompleteKeys()));
            }

            Map<String, WebResourceModuleDescriptor> loadDescriptors(Iterable<String> moduleKeys) {
                if (Iterables.isEmpty(moduleKeys)) {
                    return Collections.emptyMap();
                }
                LinkedHashMap resources = new LinkedHashMap();
                for (String moduleKey : moduleKeys) {
                    DefaultResourceDependencyResolver.this.resolveDependencies(moduleKey, resources, Collections.emptyList(), new Stack(), null);
                }
                return Collections.unmodifiableMap(resources);
            }
        };

        Cache() {
        }

        Map<String, WebResourceModuleDescriptor> resourceMap() {
            if (!DefaultResourceDependencyResolver.this.batchingConfiguration.isSuperBatchingEnabled()) {
                log.debug("Super batching not enabled, but getSuperBatchDependencies() called. Returning empty.");
                return Collections.emptyMap();
            }
            while (true) {
                SuperBatch batch = (SuperBatch)this.lazy.get();
                if (batch.version.equals(DefaultResourceDependencyResolver.this.webResourceIntegration.getSuperBatchVersion())) {
                    return batch.resources;
                }
                this.lazy.reset();
            }
        }
    }
}

