/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.AbstractDownloadableResource;
import com.atlassian.plugin.servlet.DownloadableClasspathResource;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.DownloadableWebResource;
import com.atlassian.plugin.servlet.ForwardableResource;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.util.EfficientStringUtils;
import com.atlassian.plugin.webresource.BatchPluginResource;
import com.atlassian.plugin.webresource.BatchResource;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.SinglePluginResource;
import com.atlassian.plugin.webresource.SuperBatchPluginResource;
import com.atlassian.plugin.webresource.SuperBatchSubResource;
import com.atlassian.plugin.webresource.UrlParseException;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceTransformation;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginResourceLocatorImpl
implements PluginResourceLocator {
    private static final Logger log = LoggerFactory.getLogger(PluginResourceLocatorImpl.class);
    public static final String PLUGIN_WEBRESOURCE_BATCHING_OFF = "plugin.webresource.batching.off";
    private static final String DOWNLOAD_TYPE = "download";
    private final PluginAccessor pluginAccessor;
    private final ServletContextFactory servletContextFactory;
    private final ResourceDependencyResolver dependencyResolver;
    private static final String RESOURCE_SOURCE_PARAM = "source";
    private static final String RESOURCE_BATCH_PARAM = "batch";

    public PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory) {
        this(webResourceIntegration, servletContextFactory, new DefaultResourceDependencyResolver(webResourceIntegration, new DefaultResourceBatchingConfiguration()));
    }

    public PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, ResourceBatchingConfiguration resourceBatchingConfiguration) {
        this(webResourceIntegration, servletContextFactory, new DefaultResourceDependencyResolver(webResourceIntegration, resourceBatchingConfiguration));
    }

    private PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, ResourceDependencyResolver dependencyResolver) {
        this.pluginAccessor = webResourceIntegration.getPluginAccessor();
        this.servletContextFactory = servletContextFactory;
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public boolean matches(String url) {
        return SuperBatchPluginResource.matches(url) || SuperBatchSubResource.matches(url) || SinglePluginResource.matches(url) || BatchPluginResource.matches(url);
    }

    @Override
    public DownloadableResource getDownloadableResource(String url, Map<String, String> queryParams) {
        try {
            if (SuperBatchPluginResource.matches(url)) {
                return this.locateSuperBatchPluginResource(SuperBatchPluginResource.parse(url, queryParams));
            }
            if (SuperBatchSubResource.matches(url)) {
                return this.locateSuperBatchSubPluginResource(SuperBatchSubResource.parse(url, queryParams));
            }
            if (BatchPluginResource.matches(url)) {
                return this.locateBatchPluginResource(BatchPluginResource.parse(url, queryParams));
            }
            if (SinglePluginResource.matches(url)) {
                SinglePluginResource resource = SinglePluginResource.parse(url);
                return this.locatePluginResource(resource.getModuleCompleteKey(), resource.getResourceName());
            }
        }
        catch (UrlParseException e) {
            log.error("Unable to parse URL: " + url, (Throwable)e);
        }
        return null;
    }

    private DownloadableResource locateSuperBatchPluginResource(SuperBatchPluginResource batchResource) {
        if (log.isDebugEnabled()) {
            log.debug(batchResource.toString());
        }
        for (String moduleKey : this.dependencyResolver.getSuperBatchDependencies()) {
            ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(moduleKey);
            if (moduleDescriptor == null) {
                log.info("Resource batching configuration refers to plugin that does not exist: " + moduleKey);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("searching resources in: " + moduleKey);
            }
            for (ResourceDescriptor resourceDescriptor : Iterables.filter((Iterable)moduleDescriptor.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(DOWNLOAD_TYPE))) {
                if (!this.isResourceInBatch(resourceDescriptor, batchResource)) continue;
                batchResource.add(this.locatePluginResource(moduleDescriptor.getCompleteKey(), resourceDescriptor.getName()));
            }
        }
        return batchResource;
    }

    private DownloadableResource locateSuperBatchSubPluginResource(SuperBatchSubResource superBatchSubResource) {
        for (String moduleKey : this.dependencyResolver.getSuperBatchDependencies()) {
            DownloadableResource pluginResource = this.locatePluginResource(moduleKey, superBatchSubResource.getResourceName());
            if (pluginResource == null) continue;
            return pluginResource;
        }
        log.warn("Could not locate resource in superbatch: " + superBatchSubResource.getResourceName());
        return superBatchSubResource;
    }

    private DownloadableResource locateBatchPluginResource(BatchPluginResource batchResource) {
        DownloadableResource resource;
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(batchResource.getModuleCompleteKey());
        for (ResourceDescriptor resourceDescriptor : Iterables.filter((Iterable)moduleDescriptor.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(DOWNLOAD_TYPE))) {
            if (!this.isResourceInBatch(resourceDescriptor, batchResource)) continue;
            batchResource.add(this.locatePluginResource(moduleDescriptor.getCompleteKey(), resourceDescriptor.getName()));
        }
        if (batchResource.isEmpty() && (resource = this.locatePluginResource(batchResource.getModuleCompleteKey(), batchResource.getResourceName())) != null) {
            return resource;
        }
        return batchResource;
    }

    private boolean isResourceInBatch(ResourceDescriptor resourceDescriptor, BatchResource batchResource) {
        if (!this.descriptorTypeMatchesResourceType(resourceDescriptor, batchResource.getType())) {
            return false;
        }
        if (this.skipBatch(resourceDescriptor)) {
            return false;
        }
        for (String param : BATCH_PARAMS) {
            String batchValue = batchResource.getParams().get(param);
            String resourceValue = resourceDescriptor.getParameter(param);
            if (batchValue == null && resourceValue != null) {
                return false;
            }
            if (batchValue == null || batchValue.equals(resourceValue)) continue;
            return false;
        }
        return true;
    }

    private boolean descriptorTypeMatchesResourceType(ResourceDescriptor resourceDescriptor, String type) {
        return EfficientStringUtils.endsWith((String)resourceDescriptor.getName(), (String[])new String[]{".", type});
    }

    /*
     * Enabled aggressive block sorting
     */
    private DownloadableResource locatePluginResource(String moduleCompleteKey, String resourceName) {
        DownloadableResource resource;
        if (moduleCompleteKey.indexOf(":") > -1) {
            ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(moduleCompleteKey);
            if (moduleDescriptor == null) {
                log.info("Module not found: " + moduleCompleteKey);
                return null;
            }
            resource = this.getResourceFromModule(moduleDescriptor, resourceName, "");
        } else {
            resource = this.getResourceFromPlugin(this.pluginAccessor.getPlugin(moduleCompleteKey), resourceName, "");
        }
        if (resource == null) {
            resource = this.getResourceFromPlugin(this.getPlugin(moduleCompleteKey), resourceName, "");
        }
        if (resource == null) {
            log.info("Unable to find resource for plugin: " + moduleCompleteKey + " and path: " + resourceName);
            return null;
        }
        return resource;
    }

    private Plugin getPlugin(String moduleKey) {
        if (moduleKey.indexOf(58) < 0 || moduleKey.indexOf(58) == moduleKey.length() - 1) {
            return null;
        }
        return this.pluginAccessor.getPlugin(moduleKey.substring(0, moduleKey.indexOf(58)));
    }

    private DownloadableResource getResourceFromModule(ModuleDescriptor<?> moduleDescriptor, String resourcePath, String filePath) {
        Plugin plugin = this.pluginAccessor.getPlugin(moduleDescriptor.getPluginKey());
        ResourceLocation resourceLocation = moduleDescriptor.getResourceLocation(DOWNLOAD_TYPE, resourcePath);
        if (resourceLocation != null) {
            boolean disableMinification = false;
            if (moduleDescriptor instanceof WebResourceModuleDescriptor) {
                disableMinification = ((WebResourceModuleDescriptor)moduleDescriptor).isDisableMinification();
            }
            return this.getDownloadablePluginResource(plugin, resourceLocation, moduleDescriptor, filePath, disableMinification);
        }
        String[] nextParts = this.splitLastPathPart(resourcePath);
        if (nextParts == null) {
            return null;
        }
        return this.getResourceFromModule(moduleDescriptor, nextParts[0], nextParts[1] + filePath);
    }

    private DownloadableResource getResourceFromPlugin(Plugin plugin, String resourcePath, String filePath) {
        if (plugin == null) {
            return null;
        }
        ResourceLocation resourceLocation = plugin.getResourceLocation(DOWNLOAD_TYPE, resourcePath);
        if (resourceLocation != null) {
            return this.getDownloadablePluginResource(plugin, resourceLocation, null, filePath, false);
        }
        String[] nextParts = this.splitLastPathPart(resourcePath);
        if (nextParts == null) {
            return null;
        }
        return this.getResourceFromPlugin(plugin, nextParts[0], nextParts[1] + filePath);
    }

    String[] splitLastPathPart(String resourcePath) {
        int indexOfSlash = resourcePath.lastIndexOf(47);
        if (resourcePath.endsWith("/")) {
            indexOfSlash = resourcePath.lastIndexOf(47, indexOfSlash - 1);
        }
        if (indexOfSlash < 0) {
            return null;
        }
        return new String[]{resourcePath.substring(0, indexOfSlash + 1), resourcePath.substring(indexOfSlash + 1)};
    }

    private DownloadableResource getDownloadablePluginResource(Plugin plugin, ResourceLocation resourceLocation, ModuleDescriptor descriptor, String filePath, boolean disableMinification) {
        String sourceParam = resourceLocation.getParameter(RESOURCE_SOURCE_PARAM);
        if ("webContext".equalsIgnoreCase(sourceParam)) {
            return new ForwardableResource(resourceLocation);
        }
        AbstractDownloadableResource actualResource = null;
        actualResource = "webContextStatic".equalsIgnoreCase(sourceParam) ? new DownloadableWebResource(plugin, resourceLocation, filePath, this.servletContextFactory.getServletContext(), disableMinification) : new DownloadableClasspathResource(plugin, resourceLocation, filePath);
        DownloadableClasspathResource result = actualResource;
        if (descriptor instanceof WebResourceModuleDescriptor) {
            DownloadableResource lastResource = actualResource;
            WebResourceModuleDescriptor desc = (WebResourceModuleDescriptor)descriptor;
            for (WebResourceTransformation list : desc.getTransformations()) {
                if (!list.matches(resourceLocation)) continue;
                lastResource = list.transformDownloadableResource(this.pluginAccessor, actualResource, resourceLocation, filePath);
            }
            result = lastResource;
        }
        return result;
    }

    @Override
    public List<PluginResource> getPluginResources(String moduleCompleteKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(moduleCompleteKey);
        if (moduleDescriptor == null || !(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            log.error("Error loading resource \"" + moduleCompleteKey + "\". Resource is not a Web Resource Module");
            return Collections.emptyList();
        }
        boolean singleMode = this.isBatchingOff();
        ArrayList<PluginResource> resources = new ArrayList<PluginResource>();
        for (ResourceDescriptor resourceDescriptor : moduleDescriptor.getResourceDescriptors()) {
            if (singleMode || this.skipBatch(resourceDescriptor)) {
                boolean cache = !"false".equalsIgnoreCase(resourceDescriptor.getParameter("cache"));
                resources.add(new SinglePluginResource(resourceDescriptor.getName(), moduleDescriptor.getCompleteKey(), cache, resourceDescriptor.getParameters()));
                continue;
            }
            BatchPluginResource batchResource = this.createBatchResource(moduleDescriptor.getCompleteKey(), resourceDescriptor);
            if (resources.contains(batchResource)) continue;
            resources.add(batchResource);
        }
        return resources;
    }

    Boolean isBatchingOff() {
        String explicitSetting = System.getProperty(PLUGIN_WEBRESOURCE_BATCHING_OFF);
        if (explicitSetting != null) {
            return Boolean.parseBoolean(explicitSetting);
        }
        return Boolean.parseBoolean(System.getProperty("atlassian.dev.mode"));
    }

    private boolean skipBatch(ResourceDescriptor resourceDescriptor) {
        return "false".equalsIgnoreCase(resourceDescriptor.getParameter(RESOURCE_BATCH_PARAM)) || "webContext".equalsIgnoreCase(resourceDescriptor.getParameter(RESOURCE_SOURCE_PARAM));
    }

    private BatchPluginResource createBatchResource(String moduleCompleteKey, ResourceDescriptor resourceDescriptor) {
        String name = resourceDescriptor.getName();
        String type = name.substring(name.lastIndexOf(".") + 1);
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (String param : BATCH_PARAMS) {
            String value = resourceDescriptor.getParameter(param);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            params.put(param, value);
        }
        return new BatchPluginResource(moduleCompleteKey, type, params);
    }

    @Override
    public String getResourceUrl(String moduleCompleteKey, String resourceName) {
        return new SinglePluginResource(resourceName, moduleCompleteKey, false).getUrl();
    }
}

