/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test;

import com.atlassian.plugins.osgi.test.rest.AnnotationTypeAdapter;
import com.atlassian.plugins.osgi.test.rest.TestResultDetailRepresentation;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.rules.RuleFieldValidator;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class AtlassianPluginsTestRunner
extends BlockJUnit4ClassRunner {
    public AtlassianPluginsTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public void run(RunNotifier notifier) {
        EachTestNotifier testNotifier = new EachTestNotifier(notifier, this.getDescription());
        try {
            String[] packageParts = this.getTestClass().getJavaClass().getPackage().getName().split("\\.");
            if (null == packageParts || packageParts.length < 1 || !packageParts[0].equals("it")) {
                throw new Exception("the class [" + this.getTestClass().getJavaClass().getName() + "] is annotated with @RunWith(AtlassianPluginsTestRunner.class) but it is not in the 'it.' package." + "\nPlease move the class into the 'it.' package or remove the @RunWith annotation");
            }
            this.runViaRestCall(this.getDescription(), notifier);
        }
        catch (AssumptionViolatedException e) {
            testNotifier.fireTestIgnored();
        }
        catch (StoppedByUserException e) {
            throw e;
        }
        catch (Throwable e) {
            testNotifier.addFailure(e);
        }
    }

    private void runViaRestCall(Description description, RunNotifier notifier) throws IOException {
        EachTestNotifier testNotifier;
        String resourceUrl = System.getProperty("baseurl") + "/rest/atlassiantestrunner/1.0/runtest/" + description.getClassName();
        ClientConfig config = new ClientConfig();
        config.readTimeout(1800000);
        RestClient client = new RestClient(config);
        Resource resource = client.resource(resourceUrl);
        String response = (String)resource.accept(new String[]{"application/json"}).get(String.class);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Annotation.class, (Object)new AnnotationTypeAdapter());
        Gson gson = gsonBuilder.create();
        TestResultDetailRepresentation osgiResult = (TestResultDetailRepresentation)gson.fromJson(response, TestResultDetailRepresentation.class);
        for (String string : osgiResult.getPassedMethods()) {
            testNotifier = new EachTestNotifier(notifier, Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)string));
            testNotifier.fireTestStarted();
            testNotifier.fireTestFinished();
        }
        for (String string : osgiResult.getIgnoredMethods()) {
            testNotifier = new EachTestNotifier(notifier, Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)string));
            testNotifier.fireTestIgnored();
        }
        for (Map.Entry entry : osgiResult.getFailedMethods().entrySet()) {
            String fMethodName = (String)entry.getKey();
            Failure f = (Failure)entry.getValue();
            EachTestNotifier testNotifier2 = new EachTestNotifier(notifier, Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)fMethodName));
            testNotifier2.addFailure(f.getException());
        }
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(BeforeClass.class, false, errors);
        this.validatePublicVoidNoArgMethods(AfterClass.class, false, errors);
        RuleFieldValidator.CLASS_RULE_VALIDATOR.validate(this.getTestClass(), errors);
        this.validateInstanceMethods(errors);
        RuleFieldValidator.RULE_VALIDATOR.validate(this.getTestClass(), errors);
    }
}

