/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.Debug;

public class EntityTypeUtil {
    public static boolean isType(Collection<GenericValue> thisCollection, String typeRelation, GenericValue targetType) {
        for (GenericValue value : thisCollection) {
            try {
                GenericValue related = value.getRelatedOne(typeRelation);
                if (!EntityTypeUtil.isType(related, targetType)) continue;
                return true;
            }
            catch (GenericEntityException e) {
            }
        }
        return false;
    }

    private static GenericValue getParentType(GenericValue typeValue) {
        try {
            return typeValue.getRelatedOneCache("Parent" + typeValue.getEntityName());
        }
        catch (GenericEntityException e) {
            Debug.logWarning((Throwable)((Object)e));
            return null;
        }
    }

    public static List<GenericValue> getDescendantTypes(GenericValue typeValue) {
        ArrayList<GenericValue> descendantTypes = new ArrayList<GenericValue>();
        List<GenericValue> childrenTypes = null;
        try {
            childrenTypes = typeValue.getRelatedCache("Child" + typeValue.getEntityName());
        }
        catch (GenericEntityException e) {
            Debug.logWarning((Throwable)((Object)e));
            return null;
        }
        if (childrenTypes == null) {
            return null;
        }
        descendantTypes.addAll(childrenTypes);
        for (GenericValue childrenType : childrenTypes) {
            List<GenericValue> childTypeDescendants = EntityTypeUtil.getDescendantTypes(childrenType);
            if (childTypeDescendants == null) continue;
            descendantTypes.addAll(childTypeDescendants);
        }
        return descendantTypes;
    }

    public static boolean isType(GenericValue thisType, GenericValue targetType) {
        if (thisType == null) {
            return false;
        }
        if (targetType.equals(thisType)) {
            return true;
        }
        return EntityTypeUtil.isType(EntityTypeUtil.getParentType(thisType), targetType);
    }
}

