/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilURL;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class ResourceLoader {
    protected static UtilCache<String, ResourceLoader> loaderCache = new UtilCache("resource.ResourceLoaders", 0L, 0L);
    protected static Map<String, Document> docSaveMap = new HashMap<String, Document>();
    protected String name;
    protected String prefix;
    protected String envName;

    public static InputStream loadResource(String xmlFilename, String location, String loaderName) throws GenericConfigException {
        ResourceLoader loader = ResourceLoader.getLoader(xmlFilename, loaderName);
        if (loader == null) {
            throw new IllegalArgumentException("ResourceLoader not found with name [" + loaderName + "] in " + xmlFilename);
        }
        return loader.loadResource(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceLoader getLoader(String xmlFilename, String loaderName) throws GenericConfigException {
        ResourceLoader loader = loaderCache.get(xmlFilename + "::" + loaderName);
        if (loader != null) return loader;
        Class<ResourceLoader> clazz = ResourceLoader.class;
        synchronized (ResourceLoader.class) {
            Element rootElement;
            Element loaderElement;
            loader = loaderCache.get(xmlFilename + "::" + loaderName);
            if (loader != null || (loader = ResourceLoader.makeLoader(loaderElement = UtilXml.firstChildElement(rootElement = ResourceLoader.getXmlRootElement(xmlFilename), "resource-loader", "name", loaderName))) == null) return loader;
            loaderCache.put(xmlFilename + "::" + loaderName, loader);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return loader;
        }
    }

    public static Element getXmlRootElement(String xmlFilename) throws GenericConfigException {
        Document document = ResourceLoader.getXmlDocument(xmlFilename);
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateDocument(String xmlFilename) throws GenericConfigException {
        Class<ResourceLoader> clazz = ResourceLoader.class;
        synchronized (ResourceLoader.class) {
            docSaveMap.remove(xmlFilename);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Document getXmlDocument(String xmlFilename) throws GenericConfigException {
        Document document = docSaveMap.get(xmlFilename);
        if (document != null) return document;
        Class<ResourceLoader> clazz = ResourceLoader.class;
        synchronized (ResourceLoader.class) {
            document = docSaveMap.get(xmlFilename);
            if (document != null) return document;
            URL confUrl = UtilURL.fromResource(xmlFilename);
            if (confUrl == null) {
                throw new GenericConfigException("ERROR: could not find the [" + xmlFilename + "] XML file on the classpath");
            }
            try {
                document = UtilXml.readXmlDocument(confUrl);
            }
            catch (SAXException e) {
                throw new GenericConfigException("Error reading " + xmlFilename + "", e);
            }
            catch (ParserConfigurationException e) {
                throw new GenericConfigException("Error reading " + xmlFilename + "", e);
            }
            catch (IOException e) {
                throw new GenericConfigException("Error reading " + xmlFilename + "", e);
            }
            if (document == null) return document;
            docSaveMap.put(xmlFilename, document);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return document;
        }
    }

    public static ResourceLoader makeLoader(Element loaderElement) throws GenericConfigException {
        if (loaderElement == null) {
            return null;
        }
        String loaderName = loaderElement.getAttribute("name");
        String className = loaderElement.getAttribute("class");
        ResourceLoader loader = null;
        try {
            Class<?> lClass = null;
            if (className != null && className.length() > 0) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    lClass = classLoader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    throw new GenericConfigException("Error loading Resource Loader class \"" + className + "\"", e);
                }
            }
            try {
                loader = (ResourceLoader)lClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new GenericConfigException("Error loading Resource Loader class \"" + className + "\"", e);
            }
            catch (InstantiationException e) {
                throw new GenericConfigException("Error loading Resource Loader class \"" + className + "\"", e);
            }
        }
        catch (SecurityException e) {
            throw new GenericConfigException("Error loading Resource Loader class \"" + className + "\"", e);
        }
        if (loader != null) {
            loader.init(loaderName, loaderElement.getAttribute("prefix"), loaderElement.getAttribute("prepend-env"));
        }
        return loader;
    }

    protected ResourceLoader() {
    }

    public void init(String name, String prefix, String envName) {
        this.name = name;
        this.prefix = prefix;
        this.envName = envName;
    }

    public String fullLocation(String location) {
        StringBuilder buf = new StringBuilder();
        if (this.envName != null && this.envName.length() > 0) {
            String propValue = System.getProperty(this.envName);
            if (propValue == null) {
                String errMsg = "The Java environment (-Dxxx=yyy) variable with name " + this.envName + " is not set, cannot load resource.";
                Debug.logError(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            buf.append(propValue);
        }
        if (this.prefix != null && this.prefix.length() > 0) {
            buf.append(this.prefix);
        }
        buf.append(location);
        return buf.toString();
    }

    public abstract InputStream loadResource(String var1) throws GenericConfigException;
}

