/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.applinks;

import com.atlassian.multitenant.CustomConfigHandler;
import com.atlassian.multitenant.applinks.AppLinkConfig;
import com.atlassian.multitenant.applinks.AppLinksMultiTenantConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppLinksMultiTenantConfigHandler
implements CustomConfigHandler<AppLinksMultiTenantConfig> {
    public Class<AppLinksMultiTenantConfig> getBeanClass() {
        return AppLinksMultiTenantConfig.class;
    }

    public AppLinksMultiTenantConfig parse(Element element) {
        ArrayList<AppLinkConfig> configs = new ArrayList<AppLinkConfig>();
        for (Element applink : element.elements("applink")) {
            String name = applink.attributeValue("name");
            String application = applink.attributeValue("application");
            String url = applink.attributeValue("url");
            HashMap<String, String> props = new HashMap<String, String>();
            Element properties = applink.element("properties");
            if (properties != null) {
                for (Element prop : properties.elements("property")) {
                    props.put(prop.attributeValue("key"), prop.attributeValue("value"));
                }
            }
            AppLinkConfig appLinkConfig = new AppLinkConfig(application, name, url, props);
            configs.add(appLinkConfig);
        }
        return new AppLinksMultiTenantConfig(configs);
    }

    public void writeTo(Element element, AppLinksMultiTenantConfig bean) {
        for (AppLinkConfig appLinkConfig : bean.getAppLinkConfigs()) {
            Element appLinkElement = element.addElement("applink");
            appLinkElement.addAttribute("name", appLinkConfig.getName());
            appLinkElement.addAttribute("application", appLinkConfig.getApplication());
            appLinkElement.addAttribute("url", appLinkConfig.getUrl());
            Element propertiesElement = appLinkElement.addElement("properties");
            for (Map.Entry<String, String> property : appLinkConfig.getProperties().entrySet()) {
                propertiesElement.addElement("property").addAttribute("key", property.getKey()).addAttribute("value", property.getValue());
            }
        }
    }
}

