/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util.minifier;

import com.atlassian.maven.plugins.amps.util.minifier.GoogleClosureJSMinifier;
import com.atlassian.maven.plugins.amps.util.minifier.YUIErrorReporter;
import com.googlecode.htmlcompressor.compressor.XmlCompressor;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.mozilla.javascript.ErrorReporter;

public class ResourcesMinifier {
    private static ResourcesMinifier INSTANCE;

    private ResourcesMinifier() {
    }

    public static void minify(List<Resource> resources, File outputDir, boolean compressJs, boolean compressCss, boolean useClosureForJs, Log log) throws MojoExecutionException {
        if (null == INSTANCE) {
            INSTANCE = new ResourcesMinifier();
        }
        for (Resource resource : resources) {
            INSTANCE.processResource(resource, outputDir, compressJs, compressCss, useClosureForJs, log);
        }
    }

    public void processResource(Resource resource, File outputDir, boolean compressJs, boolean compressCss, boolean useClosureForJs, Log log) throws MojoExecutionException {
        File resourceDir;
        File destDir = outputDir;
        if (StringUtils.isNotBlank((String)resource.getTargetPath())) {
            destDir = new File(outputDir, resource.getTargetPath());
        }
        if (null == (resourceDir = new File(resource.getDirectory())) || !resourceDir.exists()) {
            return;
        }
        if (compressJs) {
            this.processJs(resourceDir, destDir, resource.getExcludes(), useClosureForJs, log);
        }
        if (compressCss) {
            this.processCss(resourceDir, destDir, resource.getExcludes(), log);
        }
        this.processXml(resourceDir, destDir, resource.getExcludes(), log);
    }

    public void processXml(File resourceDir, File destDir, List<String> excludes, Log log) throws MojoExecutionException {
        log.info((CharSequence)"Compressing XML files");
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resourceDir);
        scanner.setIncludes(new String[]{"**/*.xml"});
        if (null != excludes && !excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        XmlCompressor compressor = new XmlCompressor();
        for (String name : scanner.getIncludedFiles()) {
            File sourceFile = new File(resourceDir, name);
            File destFile = new File(destDir, name);
            if (!sourceFile.exists() || !sourceFile.canRead()) continue;
            if (destFile.exists() && destFile.lastModified() > sourceFile.lastModified()) {
                log.info((CharSequence)("Nothing to do, " + destFile.getAbsolutePath() + " is younger than the original"));
                continue;
            }
            log.info((CharSequence)("compressing to " + destFile.getAbsolutePath()));
            try {
                FileUtils.forceMkdir((File)destFile.getParentFile());
                String source = FileUtils.readFileToString((File)sourceFile);
                String min = compressor.compress(source);
                FileUtils.writeStringToFile((File)destFile, (String)min);
            }
            catch (IOException e) {
                throw new MojoExecutionException("IOException when compiling JS", (Exception)e);
            }
        }
    }

    public void processJs(File resourceDir, File destDir, List<String> excludes, boolean useClosure, Log log) throws MojoExecutionException {
        if (useClosure) {
            log.info((CharSequence)"Compiling javascript using Closure");
        } else {
            log.info((CharSequence)"Compiling javascript using YUI");
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resourceDir);
        scanner.setIncludes(new String[]{"**/*.js"});
        if (null != excludes && !excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        for (String name : scanner.getIncludedFiles()) {
            File sourceFile = new File(resourceDir, name);
            String baseName = FilenameUtils.removeExtension((String)name);
            File destFile = new File(destDir, baseName + "-min.js");
            if (!sourceFile.exists() || !sourceFile.canRead()) continue;
            if (destFile.exists() && destFile.lastModified() > sourceFile.lastModified()) {
                log.info((CharSequence)("Nothing to do, " + destFile.getAbsolutePath() + " is younger than the original"));
                continue;
            }
            log.info((CharSequence)("compressing to " + destFile.getAbsolutePath()));
            if (useClosure) {
                this.closureJsCompile(sourceFile, destFile);
                continue;
            }
            this.yuiJsCompile(sourceFile, destFile, log);
        }
    }

    public void processCss(File resourceDir, File destDir, List<String> excludes, Log log) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resourceDir);
        scanner.setIncludes(new String[]{"**/*.css"});
        if (null != excludes && !excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        for (String name : scanner.getIncludedFiles()) {
            File sourceFile = new File(resourceDir, name);
            String baseName = FilenameUtils.removeExtension((String)name);
            File destFile = new File(destDir, baseName + "-min.css");
            if (!sourceFile.exists() || !sourceFile.canRead()) continue;
            if (destFile.exists() && destFile.lastModified() > sourceFile.lastModified()) {
                log.info((CharSequence)("Nothing to do, " + destFile.getAbsolutePath() + " is younger than the original"));
                continue;
            }
            log.info((CharSequence)("compressing to " + destFile.getAbsolutePath()));
            this.yuiCssCompile(sourceFile, destFile);
        }
    }

    private void closureJsCompile(File sourceFile, File destFile) throws MojoExecutionException {
        try {
            FileUtils.forceMkdir((File)destFile.getParentFile());
            String source = FileUtils.readFileToString((File)sourceFile);
            String min = GoogleClosureJSMinifier.compile(source);
            FileUtils.writeStringToFile((File)destFile, (String)min);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException when compiling JS", (Exception)e);
        }
    }

    private void yuiJsCompile(File sourceFile, File destFile, Log log) throws MojoExecutionException {
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        try {
            FileUtils.forceMkdir((File)destFile.getParentFile());
            in = new InputStreamReader(new FileInputStream(sourceFile));
            out = new OutputStreamWriter(new FileOutputStream(destFile));
            JavaScriptCompressor yui = new JavaScriptCompressor((Reader)in, (ErrorReporter)new YUIErrorReporter(log));
            yui.compress((Writer)out, -1, true, false, false, false);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("IOException when compiling JS", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Writer)out);
    }

    private void yuiCssCompile(File sourceFile, File destFile) throws MojoExecutionException {
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        try {
            FileUtils.forceMkdir((File)destFile.getParentFile());
            in = new InputStreamReader(new FileInputStream(sourceFile));
            out = new OutputStreamWriter(new FileOutputStream(destFile));
            CssCompressor yui = new CssCompressor((Reader)in);
            yui.compress((Writer)out, -1);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("IOException when compiling JS", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Writer)out);
    }
}

