/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;

public class BambooProductHandler
extends AbstractWebappProductHandler {
    public BambooProductHandler(MavenContext context, MavenGoals goals, ArtifactFactory artifactFactory) {
        super(context, goals, new BambooPluginProvider(), artifactFactory);
    }

    @Override
    public String getId() {
        return "bamboo";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.bamboo", "atlassian-bamboo-web-app", "RELEASE");
    }

    protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
        return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-bamboo-plugin", salVersion));
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.bamboo.plugins", "bamboo-plugin-test-resources");
    }

    @Override
    public int getDefaultHttpPort() {
        return 6990;
    }

    @Override
    public Map<String, String> getSystemProperties(Product ctx) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(super.getSystemProperties(ctx));
        properties.put((Object)"bamboo.home", (Object)this.getHomeDirectory(ctx).getPath());
        properties.put((Object)"org.apache.catalina.loader.WebappClassLoader.ENABLE_CLEAR_REFERENCES", (Object)"false");
        properties.put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8");
        properties.put((Object)"file.encoding", (Object)"UTF-8");
        return properties.build();
    }

    @Override
    public File getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        return new File(homeDir, "plugins");
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Collections.emptyList();
    }

    @Override
    public File getBundledPluginPath(Product ctx, File appDir) {
        return new File(appDir, "WEB-INF/classes/atlassian-bundled-plugins.zip");
    }

    @Override
    public void processHomeDirectory(Product ctx, File homeDir) throws MojoExecutionException {
        super.processHomeDirectory(ctx, homeDir);
        ConfigFileUtils.replaceAll(new File(homeDir, "/xml-data/configuration/administration.xml"), "http://(?:[^:]+|\\[.+]):8085", "http://" + ctx.getServer() + ":" + ctx.getHttpPort() + "/" + ctx.getContextPath().replaceAll("^/|/$", ""));
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product product) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(product);
        File homeDirectory = this.getHomeDirectory(product);
        replacements.add(new ConfigFileUtils.Replacement("@project-dir@", homeDirectory.getParent(), false));
        replacements.add(new ConfigFileUtils.Replacement("/bamboo-home/", "/home/", false));
        replacements.add(new ConfigFileUtils.Replacement("${bambooHome}", homeDirectory.getAbsolutePath(), false));
        return replacements;
    }

    @Override
    public List<File> getConfigFiles(Product product, File homeDirectory) {
        List<File> configFiles = super.getConfigFiles(product, homeDirectory);
        configFiles.add(new File(homeDirectory, "bamboo.cfg.xml"));
        configFiles.add(new File(homeDirectory, "database.log"));
        return configFiles;
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    public void cleanupProductHomeForZip(Product bamboo, File genDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(bamboo, genDir);
        FileUtils.deleteDir(new File(genDir, "jms-store"));
        FileUtils.deleteDir(new File(genDir, "caches"));
        FileUtils.deleteDir(new File(genDir, "logs"));
    }

    private static class BambooPluginProvider
    extends AbstractPluginProvider {
        private BambooPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-bamboo-plugin", salVersion));
        }
    }
}

