/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.filters;

import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.filters.AbstractJohnsonFilter;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class JohnsonFilter
extends AbstractJohnsonFilter {
    public static final Category log = Category.getInstance(JohnsonFilter.class);
    public static final String ALREADY_FILTERED = JohnsonFilter.class.getName() + "_already_filtered";
    public static final String URL_SETUP = "/secure/Setup!default.jspa";

    protected void handleError(JohnsonEventContainer appEventContainer, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String servletPath = JohnsonFilter.getServletPath(servletRequest);
        String contextPath = servletRequest.getContextPath();
        log.info((Object)("The application is still starting up, or there are errors.  Redirecting request from '" + servletPath + "' to '" + this.config.getErrorPath() + "'"));
        servletResponse.sendRedirect(contextPath + this.config.getErrorPath());
    }

    protected void handleNotSetup(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String servletPath = JohnsonFilter.getServletPath(servletRequest);
        String contextPath = servletRequest.getContextPath();
        log.info((Object)("The application is not yet setup.  Redirecting request from '" + servletPath + "' to '" + this.config.getSetupPath() + "'"));
        servletResponse.sendRedirect(contextPath + this.config.getSetupPath());
    }
}

