/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson;

import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.setup.ContainerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;

public class JohnsonEventContainer {
    public static String SERVLET_CONTEXT_KEY = JohnsonEventContainer.class.getName();
    private final Map<Event, Event> events = new WeakHashMap<Event, Event>();

    public static synchronized JohnsonEventContainer get(ServletContext context) {
        if (context.getAttribute(SERVLET_CONTEXT_KEY) == null) {
            JohnsonConfig johnsonConfig = JohnsonConfig.getInstance();
            ContainerFactory containerFactory = johnsonConfig.getContainerFactory();
            context.setAttribute(SERVLET_CONTEXT_KEY, (Object)containerFactory.create());
        }
        return (JohnsonEventContainer)context.getAttribute(SERVLET_CONTEXT_KEY);
    }

    public synchronized boolean hasEvents() {
        return !this.events.isEmpty();
    }

    public synchronized void addEvent(Event event) {
        this.events.put(event, event);
    }

    public synchronized void removeEvent(Event event) {
        this.events.remove(event);
    }

    public synchronized Collection getEvents() {
        return Collections.unmodifiableCollection(new ArrayList<Event>(this.events.values()));
    }
}

