/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.rest;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.mobile.rest.CommentJsonBeanExtended;
import com.atlassian.jira.mobile.rest.util.BaseRestResource;
import com.atlassian.jira.mobile.rest.util.IssueFinder;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.math.NumberUtils;

@Path(value="/comment")
@AnonymousAllowed
public class CommentResource
extends BaseRestResource {
    private static final String COMMENT_FIELD_KEY = "comment";
    private final CommentService commentService;
    private final ProjectRoleManager projectRoleManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final RendererManager rendererManager;
    private final IssueFinder issueFinder;
    private final FieldLayoutManager fieldLayoutManager;
    private final UserPreferencesManager userPreferencesManager;
    private final WatcherService watcherService;

    public CommentResource(JiraAuthenticationContext jiraAuthenticationContext, CommentService commentService, ProjectRoleManager projectRoleManager, JiraBaseUrls jiraBaseUrls, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, IssueFinder issueFinder, FieldLayoutManager fieldLayoutManager, UserPreferencesManager userPreferencesManager, WatcherService watcherService) {
        super(CommentResource.class, jiraAuthenticationContext);
        this.commentService = commentService;
        this.projectRoleManager = projectRoleManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.rendererManager = rendererManager;
        this.issueFinder = issueFinder;
        this.fieldLayoutManager = fieldLayoutManager;
        this.userPreferencesManager = userPreferencesManager;
        this.watcherService = watcherService;
    }

    @POST
    @Path(value="/{issueIdOrKey}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addComment(final @PathParam(value="issueIdOrKey") String issueIdOrKey, final CommentJsonBean request) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                MutableIssue issue = CommentResource.this.issueFinder.findIssue(issueIdOrKey);
                if (issue == null) {
                    return CommentResource.this.notFoundRequest("404.issue.not.present");
                }
                if (CommentResource.this.issueFinder.checkIssuePermission((Issue)issue) == null) {
                    if (CommentResource.this.getLoggedInUser() == null) {
                        return CommentResource.this.unauthorizedRequest("401.login.required");
                    }
                    return CommentResource.this.forbiddenRequest("403.no.permission");
                }
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                CommentVisibility commentVisibility = CommentResource.this.getCommentVisibilityParams(request);
                CommentResource.this.commentService.isValidAllCommentData(CommentResource.this.getLoggedInUser(), (Issue)issue, request.getBody(), commentVisibility.group, commentVisibility.roleId != null ? commentVisibility.roleId.toString() : null, (com.atlassian.jira.util.ErrorCollection)errorCollection);
                if (!errorCollection.hasAnyErrors()) {
                    Comment comment = CommentResource.this.commentService.create(CommentResource.this.getLoggedInUser(), (Issue)issue, request.getBody(), commentVisibility.group, commentVisibility.roleId, true, (com.atlassian.jira.util.ErrorCollection)errorCollection);
                    if (!errorCollection.hasAnyErrors()) {
                        CommentJsonBean renderedEntity = CommentJsonBean.renderedShortBean((Comment)comment, (JiraBaseUrls)CommentResource.this.jiraBaseUrls, (ProjectRoleManager)CommentResource.this.projectRoleManager, (DateTimeFormatterFactory)CommentResource.this.dateTimeFormatterFactory, (RendererManager)CommentResource.this.rendererManager, (String)CommentResource.this.getCommentFieldRendererType((Issue)issue), (IssueRenderContext)issue.getIssueRenderContext());
                        boolean isAutowatchEnabled = CommentResource.this.isAutoWatchEnabledForUser(CommentResource.this.getLoggedInUser(), (Issue)issue);
                        String created = comment.getCreated() == null ? "" : CommentResource.this.dateTimeFormatterFactory.formatter().forLoggedInUser().format(comment.getCreated());
                        String updated = comment.getUpdated() == null ? "" : CommentResource.this.dateTimeFormatterFactory.formatter().forLoggedInUser().format(comment.getUpdated());
                        CommentJsonBeanExtended response = new CommentJsonBeanExtended(renderedEntity, isAutowatchEnabled, created, updated);
                        return Response.status((Response.Status)Response.Status.CREATED).location(CommentResource.this.getUri(renderedEntity)).entity((Object)response).cacheControl(CacheControl.never()).build();
                    }
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build();
            }
        });
    }

    private String getCommentFieldRendererType(Issue issue) {
        FieldLayout layout = this.fieldLayoutManager.getFieldLayout(issue);
        List fieldLayoutItems = layout.getVisibleLayoutItems(this.getLoggedInUser(), issue.getProjectObject(), CollectionBuilder.list((Object[])new String[]{issue.getIssueTypeObject().getId()}));
        for (FieldLayoutItem item : fieldLayoutItems) {
            if (!COMMENT_FIELD_KEY.equals(item.getOrderableField().getId())) continue;
            return item.getRendererType();
        }
        return null;
    }

    private CommentVisibility getCommentVisibilityParams(CommentJsonBean request) {
        if (request.getVisibility() != null) {
            VisibilityJsonBean visibility = request.getVisibility();
            if (visibility.type == VisibilityJsonBean.VisibilityType.role) {
                Long longValue = NumberUtils.createLong((String)visibility.value);
                if (longValue != null) {
                    Long role = this.projectRoleManager.getProjectRole(longValue).getId();
                    return new CommentVisibility(VisibilityJsonBean.VisibilityType.role, null, role);
                }
            } else {
                String group = visibility.value;
                return new CommentVisibility(VisibilityJsonBean.VisibilityType.group, group, null);
            }
        }
        return new CommentVisibility(null, null, null);
    }

    private URI getUri(CommentJsonBean comment) {
        try {
            return new URI(comment.getSelf());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private boolean isAutoWatchEnabledForUser(ApplicationUser user, Issue issue) {
        if (this.watcherService.isWatchingEnabled()) {
            boolean hasPermission = user != null;
            boolean isAutowatching = !this.userPreferencesManager.getPreferences(user).getBoolean("user.autowatch.disabled");
            return hasPermission && isAutowatching;
        }
        return false;
    }

    private class CommentVisibility {
        VisibilityJsonBean.VisibilityType type;
        String group;
        Long roleId;

        private CommentVisibility(VisibilityJsonBean.VisibilityType type, String group, Long roleId) {
            this.type = type;
            this.group = group;
            this.roleId = roleId;
        }
    }
}

